Article

# Gamification in Science Education. A Systematic Review of the Literature

Michail Kalogiannakis $\ast ( 0 )$ , Stamatios Papadakis $\textcircled{1}$ and Alkinoos-Ioannis Zourmpakis

Citation: Kalogiannakis, M.; Papadakis, S.; Zourmpakis, A.-I. Gamification in Science Education. A Systematic Review of the Literature. Educ. Sci. 2021, 11, 22. https:// doi.org/10.3390/educsci11010022

Received: 7 December 2020   
Accepted: 30 December 2020   
Published: 6 January 2021

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

Department of Preschool Education, Faculty of Education, University of Crete, 74100 Crete, Greece; stpapadakis@gmail.com (S.P.); alkiszzz@gmail.com (A.-I.Z.)   
\* Correspondence: mkalogian@uoc.gr

Abstract: The implementation of gamification in education has attracted many researchers to increase engagement and achieve learning more effectively. Implementing technology in science curricula has seen a massive influx over the past years to stop the decline in students’ motivation towards science learning and promote scientific thinking. This study’s objective is to present the empirical findings of the state-of-the-art literature on the use of gamification in science education. Therefore, we performed a systematic literature review of 24 empirical research papers published in various electronic databases and the web search engine for scholarly literature and academic resources, Google Scholar, between 2012 and 2020. This review reveals the latest emerging trends of gamification in science education while revealing the literature gap, challenges, impediments, and extending the possibilities for future research directions. It examines the conflicting findings of other studies and provides a framework and insight for future researchers regarding content areas, educational levels, theoretical models, outcomes, methodologies, game elements, and assessment tools.

Keywords: gamification; science education; motivation; engagement; systematic literature review

# 1. Introduction

Technological advancements and their rapid development always create new and exciting ways to engage students learning and meet the growing needs of education. At the same time, traditional teaching methods or even applications that are still used today always prove to be, at least, insufficient [1]. Science education is widely considered one of the most integral parts of today’s education, according to the National Research Council [2], since it is responsible for creating scientifically literate citizens and promoting crucial 21stcentury skills like adaptability or problem-solving. Consequently, there has been a great interest in tools and means that facilitate scientific thinking and the educational theories implemented in them [3,4].

In the past few years, one technological trend that has been heavily focused on by researchers in many fields, including education, is gamification [5,6]. The use of gamification in education utilizes gaming elements and aesthetics to enhance students’ motivation and promote learning [7,8]. The core idea in gamification lies behind the logic that the game elements’ motivational strength can be transferred in an educational context [9]. The implementation of gamification in science education has been an intriguing area for many researchers as it is something familiar to students, and at the same time, it draws their interest [10,11]. Moreover, it can facilitate scientific thinking [3] compatible with scientific theories, methodologies, and learning strategies related to education and gamification [12]. However, while the implementation of gamification has been generally considered successful around user engagement [13], its impact on learning outcomes has often been questioned, with research results varying among individuals, creating a divide between researchers, and questioning its benefits. Thus, the growing popularity combined with mixed results has further increased the need to explore the specific processes relating to education to figure out their impact.

Many literature reviews regarding gamification in education have been conducted to understand its impact on students’ learning [14,15]. However, contradicting results, implementation in different educational levels, the lack of specific assessment tools, the ad hoc use of gaming elements, and the general reports from scholars that more studies are required in this field reveal a gap in the literature [16,17].

First of all, mixed results in regard to students learning results have quite baffled researchers. Previously literature reviews on the use of gamification in education have tried to investigate its potential in learning results. The findings, though positive, are considered of medium effect and not conclusive. In addition, although there is some evidence in regard to the implementation of gamification in different educational levels, this evidence is mostly affected by the fact that a significant portion of the studies in gamification in education is associated with computer sciences lessons, which are more commonly found in higher education [15].

Moreover, gamification and digital technologies have tremendous potential in using specific assessment tools, such as real-time tracking points and internet cookies. However, there have been no efforts to measure the degree of implementation in gamification in education as far as we are aware. According to Mora et al. [18], gamification applications often lack a formal design process. They do not always follow a theoretical framework, and the role of the gaming elements within the gamified application does not always have the desired effect it is intended [11,15]. Furthermore, the lack of literature reviews regarding gamification in science education, apart from the Loganathan et al. [11], as far as we are aware, also highlights a need for a systematic review. For instance, in Loganathan et al. [11] study, a correlation of educational outcomes with one learning theory associated with science education and gamification was noted. However, no other comparison was made, or any other learning theories and strategies could associate were mentioned.

This study aims to make an extensive and comprehensive critical review. It will investigate, examine, and identify key gamification features in science education and elements of success and theoretical gaps in pedagogy and contribute to gamification in science education at all educational levels. Only peer-reviewed empirical studies from journals and conferences were selected in the systematic review to maximize our findings’ validity, gather unbiased information, and increase as much as possible the generation of evidence [19]. Thus, we follow a scoping review of relevant empirical studies and trends, provide insight, and illuminate the state of current practices and compile recommendations to future researchers to create their theoretical models and gamification designs based on the current evaluation practices. Therefore, we opted for a mixed review, which is consistent with other similar studies in gamification [16,20].

This systematic review’s primary purpose is to provide researchers with a more precise understanding of gamification research in science education. More specifically, this research aims to address what is known from the existing literature about the effects of gamification in science education on motivation and learning in students from primary/secondary or higher education compared to learning materials without gamification.

# 2. Review of Literature

# 2.1. Gamification

Gamification was introduced in the last decade and has focused on many different fields, including education [21]. Gamification, according to Kapp ([7], p. 10), is defined as “the use of game design elements, game-play mechanics, aesthetics, and game thinking for non-game applications to motivate students.” Although there has not been a universal term for gamification, most of them share some standard features. Lately, though, gamification has focused to digitally engage students, utilizing platforms or applications with the use of digital devices like tablets, smartphones, or computers [22].

One very closely related term to gamification is serious games. Both try to make use of some aspects of games to accomplish some goals beyond entertainment. Their main differences lie primarily in how their environments are related to the educational process [23]. In a serious game, the educational goals are often not known to the players, the environment does not necessarily represent reality, and its main focus is to motivate the student to “play” the game without having a limit in the number of game mechanics [23]. On the other hand, in a gamified application, all learning goals are always visible and known to the users from the get-go. The environment represents real-world problems and situations, while its purpose is to increase the levels of enjoyment, satisfaction, and motivation of the player who engages with the application by utilizing a certain amount of game features [21,22]. The most distinct difference between serious games and gamification in education, according to Landers [24], is the process of learning. In serious games, learning is affected directly as the instructional content within the application causes learning. However, in gamification, learning is mainly achieved indirectly “as the goal of gamification is to alter a contextual learner behavior or attitude” ([24], p. 759). All gamification applications have two sets of goals, the learning goals that correspond to the content and the playful goals related to the user experiences they trigger, such as enjoyment and satisfaction [25,26]. The gamification content defines the learning goals, whereas the playful goals are linked with the game design elements implemented in the gamification application, their motivational power, type, and the psychological needs they correspond to [21]. According to Huang and Soman [27], learning goals and playful goals are not distinct. Gamification’s primary goal is to affect factors, such as motivation, to influence a learning-related behavior, like engagement with the educational content, and achieve a learning outcome. Therefore, gamification’s role is to “affect psychological factors that mediate the learning outcomes” ([28], p. 4). However, the way the instructional content is presented is equally important in learning outcomes as it can lead to a decline in performance or knowledge and skills acquisition despite the increase in participation and effort [27]. A gamified learning environment needs to be carefully designed, especially around the gaming elements it utilizes and has explicit and clear instructions [29]. Otherwise, the students could get distracted from the learning goals [30,31].

# 2.2. Gaming Elements

Game-mechanics are core parts of gamification that generally represent the application elements, which can be found in games like storytelling, badges, points, ladders, and avatars. Gamification is characterized by integrating design elements or activity formats associated with games into an educational context, whether digitally or not [32]. A crucial part of gamification design is recognizing, selecting, and utilizing game design elements to impact students’ engagement and motivation [7,33]. However, there are many cases of gamification applications that do not follow a formal process design [18]. They follow procedures and implement elements in an ad hoc fashion, such as using a leaderboard system, without considering other factors, such as students’ psychological needs and demographics [18]. These ad hoc approaches create a significant problem since they make procedures and features challenging to apply in other case studies. Therefore, many researchers have stressed the importance of categorizing and identifying the gaming elements’ advantages and disadvantages, effects, and general impact when applied in an educational environment and selecting the most beneficial ones according to formal procedures and specific goals [24,34].

# 2.3. Theories Underpinning Gamification

The main reason behind the efforts to use gamified applications has been their theoretical ability to harness games’ motivational power. Consequently, in terms of theories related to gamification, while several theories can be linked, the more common one associated with its fundamental purpose, motivation, is the self-determination theory [21]. While other theories like Bandura’s Self-Efficacy Theory or the Goal Setting Theory take into account a part of motivational aspects [21], i.e., extrinsic motivation, self-determination theory (SDT) encompasses, to some extent, a more holistic and comprehensive approach, including both intrinsic and extrinsic motivations and the connections between them [35].

SDT posits around three basic psychological needs that all individuals have and strive to fulfill, relatedness, autonomy, and competence. These needs are connected and enhance intrinsic motivations, namely acting inherently because of interest and enjoyment, and extrinsic motivation, i.e., acting due to a reward or incentive [35]. According to Deci and Ryan [36], a continuum between intrinsic motivation types that begin from intrinsic motivation continues into the three types of extrinsic motivation [37], identified regulations, introjected regulations, and external regulations end with motivation. Though the main difference between intrinsic’s and extrinsic’s motivation is the origin of each type of motivation, from within or outside the intended activity, people tend to try and internalize extrinsic motivation to identify them as their own and have a close resemblance with intrinsic motivation [36]. The degree of internalization in extrinsic motivation defines how closely they are to be fully internalized. They can be accepted and look like intrinsic motivation (identified regulation), neither internalized nor perceived ultimately as extrinsic (introjected regulations), or the complete fail of internalization and being perceived as purely extrinsic (external regulations) [32]. Though intrinsic and extrinsic motivation can lead to performance gains, only intrinsic motivation is directly linked to significantly enhanced mental health, creativity, learning outcomes, and lasting engagement in an activity [35,38]. The degree of internalization depends on the person’s perception of the events as supporting and informational that aids them to achieve their psychological needs [39,40]. As the fulfillment of those basic psychological needs in gamified practices correlates with games’ primary focus, behavioral and emotional engagement increases enjoyment and participation and enhances the students’ appeal and disposition towards learning [26,41]. SDT has been extensively applied to the context of video games [42,43] and has been one of the primary target theories for gamification as well [26,34,44]. Designing a gamified environment in accordance to SDT would require elements that would be able to fulfill at least one of the three basic psychological needs, such as different levels or tasks (autonomy), social interaction (relatedness), and some type of progress bar or achievement indicator (competence) [26].

Another theory that is often associated with gamification is the goal-setting theory (Landers, 2015). Goals that are straightforward, specific, make sense, and not too tricky to effectively increase performance and engagement [45]. According to the goal-setting theory, four factors connect the goals situated with the individual’s performance. The individuals’ commitment towards their goal; the feedback they receive for their action; the complexity of the activity they perform; and the situational constraints that relate to their tasks, such as time limit or role overload [24,45,46]. Designing a gamification application by applying the goal-setting theory principles would require the indication of progress, some challenges, levels of achievement, a type of feedback, and some sort of competition [47].

Additionally, another prevalent concept that is very closely related to gamification is flow theory. Although flow theory is more of a process than a theory [48], it is also a pervasive approach to describing digital-related studies [49]. Flow theory describes conditions and dimensions where an optimal psychological and psychical state can maximize enjoyment and engagement [50]. Flow emphasizes internal processes and experiences correlating closely with intrinsic motivation [48]. There is a particular variety of conditions to achieve an optimal experience. However, according to Matallaoui et al. [51], clear and close-related goals, a balance between challenges, skill acquisition, and emphasizing the relation between action and awareness is critical. Their importance in designing a gamified environment is also significant as some of them incorporate pre-conditions of flow [48] and have a close relation to motivation and engagement [51]. Designing a gamification application underflow theory would require specific and understandable goals, immediate feedback, progress indicator, and adequately balanced challenges based on the users’ general skill set with perceived usefulness for completing them [47].

# 2.4. Gamification in Educational Settings and Science Education

The use of games in an educational setting is not something new; however, the concept and implementation of gamification in the educational sector have been introduced very recently [52]. Several researchers in gamification have indicated that many contextual factors affect its use in education, including the content related to the gamified activity and the population it is addressed and used [53–55]. Although game-based learning literature has been more distinct on primary and secondary education [56], gamification has focused on higher education than primary or secondary education [5,57,58]. Though recent evidence suggests that the gap of gamification implementation between educational levels has receded [59], it is unclear if this holds true and whether gamification impact depends on a target population. Furthermore, most gamification implementation studies related to computer and information courses, although other domains such as mathematics, literature, and science, have also been researched [5,59].

Science education is an integral part of 21st-century education, but several issues need to be addressed. One of the most critical problems that science education faces is creating negative emotions and experiences. They have a challenging time understanding science courses resulting in increasing rejection and dropout rates [60,61]. Teachers’ lack of interest, knowledge of relative content, lack of pedagogy related to teaching science, and a generally negative experience can also be shifted into their students [62]. Furthermore, enhancing the way students investigate and understand phenomena and concepts while promoting active and scientific thinking is critical [63,64]. Therefore, the integration of gamification in science education has been significantly increased to improve engagement, joyfulness, and motivation to support relevant activities that contribute to science education [11,12,65]. Gamifying science lessons by implementing gaming mechanics and elements can potentially lift the obstacles science education faces, increasing motivation, cognitive and metacognitive achievements, and students’ enjoyment [3,66]. Unlike a real school laboratory, gamification applications can provide a safe and real-like environment for the students to experiment without any danger or fear of accidents [67].

Additionally, students are encouraged to be proactive, try new ways, and repeat tasks if they want to while remaining anonymous and reducing their fear of failure [68]. Moreover, the implementation of gamification is quite often associated with socially interactive and constructive learning environments [69]. Students who engage in a gamified environment have become more receptive and willing to engage in future similar teaching [9].

However, gamification has often been criticized for not affecting students’ learning or having adverse effects on students’ test results [70,71]. In addition, like most digital learning technologies, gamification has been suffering from "traditional" problems related to these learning technologies, such as high software development cost, teacher education, and support materials for teachers [72,73]. Moreover, poor planning of the gamified environment, like complicating instructions or the ad hoc use of gaming elements and mechanics, such as increased levels of difficulty or over sophisticated graphics, could disorientate students, decrease students’ intrinsic motivation [74], performance [71,75] and lead to deviant behaviors, like apathy [76].

Significant efforts have been made in finding innovative teaching practices to engage students in science education [6,77]. In gamification, based on game-based and active learning concepts, students have specific learning goals and increased intrinsic and extrinsic motivation to complete their activity [12,78,79].

Nevertheless, it can also support various other teaching practices like inquiry-based learning, project-based learning, or experiential learning [80]. Scientific inquiry has been one of the most recognized and integral objectives for achieving science literacy and creating a scientifically literate workforce, science education’s main objective [2]. As science is an inquiry process [81], inquiry-based learning has been extensively implemented, helping students learn science by taking the role of scientists, actively planning, engaging, and executing inquiry activities rather than receiving passive knowledge through the teachers [82]. A few studies have shown positive results in students’ science learning acquisition and improving cognitive and higher-order thinking abilities [83,84].

With the development of new technological advancements and tools, like gamification [11], researchers have started utilizing them to support scientific inquiry activities and deal, at the same time, with some difficulties associated with inquiry-based learning, such as increased time consumption, lack of the necessary instructions from teachers or a deficiency on how to implement inquiry activities in traditional science classrooms [82,85,86]. Furthermore, gamification applications can provide additional information on learners learning progress and requirements in a non-invasive way [87]. It can gather data in real-time, give feedback, and provide a more detailed image of the students’ progress and characteristics than traditional assessment methods. For instance, this can be achieved by real-time tracking points, levels, internet cookies, and eye-tracking [56,88]. These sophisticated assessment methods have the potential to provide us a more detailed and holistic depiction of the user’s skills and knowledge than the standardized assessment methods can [56,89].

Therefore, gamification applications have been the focus of many fields, including education. Notably, science education, in which a global decline in student enrollment and academic results [77] and a lack of positive emotions towards science learning has been observed [60], is also a field that researchers seem to be able to benefit from gamification. Although there has been some evidence that gamification can increase student enjoyment and motivation [66], gamification has baffled researchers with various mixed results in the field of education regarding student achievement results [90,91]. Further, it remains unclear whether the lack of studies in primary and secondary education is associated with the education levels, other target group characteristics, such as demographics [54], or to the content area gamification is mostly used, i.e., computer and information courses, which is most usually associated with higher education [92].

Many researchers have highlighted the need to understand the connection in gamification between theory, gaming elements, and learning outcomes [3,82,93,94]. Is gamification a valuable tool in science education in general, and how is gamification affected by the theory, gaming elements, and learning strategies applied in it?

# 3. Review Questions

To examine what exists in the current literature on gamification in science education, the following questions were set up and used:

• Research question 1: What methodology and assessment tools were used?   
• Research question 2: What are the content areas, educational levels, and educational contexts?   
• Research question 3: What theory of learning is utilized, and what gaming elements are embedded in gaming apps?   
• Research question 4: What were the motivational and/or educational outcomes?

All research questions were derived from reviewing and connecting the results of gamified applications used in science education with the learning theories, elements, outcomes, educational levels, and contexts and how those findings were assessed.

# 4. Method

To provide a concrete and comprehensive understanding of gamification in science education, we conducted a systematic literature review (SLR) using systematic and specific methods to identify, select and amass all relevant research material directly and connected to specific research questions [95].

The process and methodology used to conduct a systematic review in this study is the PRISMA model (Preferred Reporting Items for Systematic Reviews and Meta-Analyses) [96]. The process that was followed was specific and included the following steps [97]:

Specifying research questions Search on databases

• Inclusion/Exclusion criteria • Selection of studies • Analysis and extraction of data • Summary and interpretation of findings Writing the review report

# 4.1. Journal Research Methodology

This systematic review facilitated a general search of some specific electronic databases and the web search engine for scholarly literature and academic resources, Google Scholar. To increase study credibility and integrity, only peer-reviewed articles or conference papers were included. The databases searched were Science Direct, Eric, Wiley Online Library, SpringerLink, Sage Journals, Taylor & Francis Online, and JSTOR. Google Scholar was also selected due to currently be the most comprehensive academic search engine [98] and to include articles published outside educational journals that provide relevant information [99].

Gamification has often been associated and referred to with different terms. For example, gamified applications, gamified environments, gamification, and game-based application refer to gamification content. According to Cronin et al. ([100], p. 41), considering alternative terms with equivalent meaning is vital to maximizing the amount of information accumulated in an SLR. Thus, alternative keywords from the database thesaurus were identified and used in different combinations by utilizing “Boolean” operators (AND, OR) [100]. The terms used in the search string included core concepts that align with our research topic and research questions such as “gamification”, “science education”, “gaming elements”, and “educational level”, as well as synonyms as shown in Table 1.

Table 1. Core concepts and synonyms.   

<html><body><table><tr><td>Core Concepts</td><td> Synonyms</td></tr><tr><td>Gamification</td><td> Gamification, gamified, gamified environment, gamified application, applied game design,</td></tr><tr><td>Science education</td><td>Scientific education, science teaching,science education, the teaching of science,chemistry, geology physics, biology, astronomy, natural sciences, earth sciences</td></tr><tr><td>Educational level</td><td>Education, primary education, elementary education, K-12 education, graded school education, secondary education,highshool,junior highshool, middle hool,prepshool, preparatory school,senior high shool, college preparatoryshool, intermediate shool, higher education, further education, graduate school education, tertiary-level education, university education</td></tr><tr><td>Gaming elements</td><td>Gaming elements, gaming mechanics, gaming components, gaming factors, gaming constituent</td></tr></table></body></html>

After testing and reviewing the specific syntax that each database required, a search string was created by compiling Boolean and simple operators with parentheses. The search sting that was used was (“gamification” OR “gamified”, OR “gamified environment”, OR “gamified application”, OR “applied game design”,) AND (“scientific education” OR “science teaching” OR “teaching of science”, OR “science education” OR “chemistry” OR “geology”, OR “physics” OR “biology” OR “astronomy” OR “natural sciences” OR “earth sciences”) AND (“education” OR “primary education” OR “elementary education” OR “K-12 education” OR “graded school education” OR “secondary education” OR “high school” OR “junior high school” OR “middle school” OR “prep school” OR “preparatory school” OR “senior high school” OR “college preparatory school” OR “intermediate school” OR “higher education” OR “further education” OR “graduate school education” OR “tertiary-level education” OR “university education”) OR (“gaming elements” OR “gaming mechanics” OR “gaming components” OR “gaming factors” OR “gaming constituent”). In most cases, the search string that included all core concepts and their synonyms was utilized. In the case of Google Scholar, the 1000 most relevant results were selected. However, two databases, Science Direct and JSTOR, had some restrictions in the Boolean connectors (max 8), and the characters used in the search string (200 characters max). Thus, the search string in those two databases was adjusted, and multiple search stings were used to cover as many related articles as possible in these databases. The “educational level” and “gaming elements” core concepts were restricted in the terms “education” and “gaming elements”, whereas the synonyms in the “Gamification” core concept were all included. The nine synonyms in the core concept “Science education” were separated and used individually to create nine search strings used in those particular databases (Table A2 in Appendix A). Additionally, the database search was adjusted based on the inclusion or exclusion criteria if the database had that option available, such as publication date, language.

# 4.2. Inclusion/Exclusion Criteria

In the interest of conducting our research, we set specific criteria that would help us sift through the variant studies, select, and include those relevant to our research topic, and exclude the studies that failed to meet some necessary conditions. The inclusion and exclusion criteria were as follows:

Inclusion:

1. The study must be empirical (quantitative, qualitative, or mixed methods) in a learning environment.   
2. A gamified practice was used in the study with at least one distinct game element. The gamified practice must have been used on learners, and empirical data must be included.   
3. The study was conducted in an educational environment (primary, secondary or higher education).   
4. The study was related to a science-related content area (chemistry, physics, biologyhealth education, natural sciences).   
5. The article is a peer-reviewed or a conference paper.   
6. The article is published from 2012 to 2020. To include gamification practices with new interactive technologies solely, we investigated studies from the past eight years.

Exclusion:

1. The study is not written in English.   
2. The study does not mention the game elements that were used.   
3. The study only includes opinions about gamified practice.   
4. The study is listed in another database.   
5. The study is only published as an abstract.

# 4.3. Review Process

Due to the high quantity of results from the databases, additional criteria were chosen in the present literature research: time frame and logic [101]. In this SLR, only the first 300 results of each database search were analyzed, following Haddaway et al. [102] recommendations. If the number of results in each search in the databases was less than 300, all articles would be screened.

The initial search results in all databases produced a total of 5754 articles, as shown in Table 2. Based on duplicates, published date, and title review, and, based on relevance, abstract review, 5697 articles were excluded. The remaining 57 were scoped for further information. Studies that did not include the specific science education topics were 29 and were excluded too. The remaining 28 articles were carefully thoroughly reviewed in relevance to our criteria and research questions. A thematic analysis procedure was followed [103] during this process. Each author kept separate notes and read each article multiple times to properly comprehend its content, procedures, and methods used and findings displayed. All the information was then compared and discussed. From the 28 articles, four studies did not include any clear empirical evidence about the gamified practice and were removed. The 24 articles that composed the final dataset were included in the systematic review (Table 2). The PRISMA process that we followed is depicted in Figure 1.

Table 2. Data source and systematic review stages.   

<html><body><table><tr><td>Data Source</td><td>(dentitcaten)</td><td>2ndeting)</td><td>3rd bity)</td><td>4thbity)</td><td>5thde</td></tr><tr><td>Eric</td><td>74</td><td>74</td><td>12</td><td>6</td><td>6</td></tr><tr><td>Wiley Online Library</td><td>300</td><td>300</td><td>3</td><td>1</td><td>2</td></tr><tr><td>SpringerLink</td><td>300</td><td>300</td><td>7</td><td>5</td><td>5</td></tr><tr><td>Sage Journals</td><td>171</td><td>171</td><td>7</td><td>2</td><td>2</td></tr><tr><td>Taylor &amp; Francis Online</td><td>241</td><td>241</td><td>3</td><td>0</td><td>0</td></tr><tr><td>Google scholar</td><td>1000</td><td>1000</td><td>17</td><td>11</td><td>8</td></tr><tr><td>JSTOR</td><td>368</td><td>368</td><td>2</td><td>0</td><td>0</td></tr><tr><td>Science Direct</td><td>3300</td><td>3300</td><td>6</td><td>1</td><td>1</td></tr></table></body></html>

![](images/8278be73f4f5f8218abaaace912410f5d7a449c355d9060f5c05a881d557b4f3.jpg)  
Figure 1. PRISMA review process.Figure 1. PRISMA review process.

# Comment 2).4.4. Data Extraction and Analysis

1st Stage 2nd Stage 3rd Stage 4th Stage 5th Stage The 24 articles (Table 3) were further analyzed to provide aggregated data findData Source ings concerning the research questions. Providing validity and credibility to the data Eric 74 74 12 6 6extracted from the studies is of paramount importance. Thus, a triangulation process was followed [104]. At first, a thorough review and analysis of the trends of gamified studSpringerLink 300 300 7 5 5ies, theories, and methodologies, purposes, effects, and connections to science education were conducted.

Table 3. Articles included in the systematic review.   

<html><body><table><tr><td>No.</td><td>Author(s)</td><td>Educational Level</td><td> Content Area</td><td> Educational Context</td></tr><tr><td>1</td><td>Sanchez-Martin et al. [105]</td><td>Higher</td><td>Natural Sciences</td><td>Self-developed gamification through a Web-based gamified platform (&quot;Moodle&quot;)</td></tr><tr><td>2.</td><td>Bjaelde et al. [106]</td><td>Higher</td><td>Physics</td><td></td></tr><tr><td>3</td><td>Sanchez-ivasRuiz-Pamrer</td><td> Primary</td><td>Natural sciences</td><td> Self-developed digital assessment test</td></tr><tr><td>4.</td><td>Fleischmann &amp; Ariel[108]</td><td>Higher</td><td>Biology</td><td>Web-based interactive multimedia application-practice tool (&quot;ELISA Learning Tool Prototype&quot;)</td></tr><tr><td>5.</td><td>López Carill,et al. [109]</td><td>Higher</td><td> Natural sciences</td><td>Gamified laboratory practice- use of web-based gamified platforms (&quot;ClassDojo” and&quot;Kahoot&quot;)</td></tr><tr><td>6</td><td> Sahin and Namli,[110]</td><td>Primary</td><td> Natural sciences</td><td></td></tr><tr><td>7</td><td> Sanmugam et al. [11]</td><td> Secondary</td><td> Natural sciences</td><td> WebaeGamfed pafom</td></tr><tr><td>8</td><td>Khan et al. [112]</td><td>Secondary</td><td>Physics</td><td> Self-developed gamified application</td></tr><tr><td>9.</td><td>Zamora-Polo et al. [113]</td><td>Primary</td><td>Natural Sciences</td><td>Web-based gamified platforms and game-based activities (&quot;Kahoot&quot;,</td></tr><tr><td>10.</td><td>Yapici and Karakoyun [114]</td><td>Higher</td><td>Biology</td><td>&quot;Socrative”,&quot;Quizziz&quot;) Web-basedGanifie patform</td></tr><tr><td>11.</td><td>Lai and Foon [115]</td><td> Secondary</td><td>Physics</td><td>Sef-devepe basedGamfied</td></tr><tr><td>12.</td><td>Tsai [82]</td><td>Secondary</td><td>Physics</td><td>Self-developed gamified computer-simulatedscience inquiry environment</td></tr><tr><td>13.</td><td>Pesare et al. [116]</td><td>Higher</td><td>Biology</td><td>Pre-existed gamification simulations (&quot;Simulation of Clinical Cases&quot; and &quot;Edugame&quot;)</td></tr><tr><td>14.</td><td>Jenkins and Mason [117]</td><td>Higher</td><td>Chemistry</td><td> ef-de</td></tr><tr><td>15.</td><td>Fan and Xiao [118]</td><td>Secondary</td><td>Biology</td><td>Selfee</td></tr><tr><td>16.</td><td>Hursen and Bas [119]</td><td>Primary</td><td>Biology</td><td>Gamification application (&quot;ClassDojo&quot;)</td></tr><tr><td>17.</td><td>Bonde et al. [120]</td><td> Secondary</td><td>Biotechnology</td><td>Gamiied loratry simatien</td></tr><tr><td>18.</td><td>Kingsley and Melissa [121]</td><td>Primary</td><td>Natural sciences</td><td>Gamification platform (&quot;3D GameLab&quot;)</td></tr><tr><td>19.</td><td>Owens [122]</td><td>Higher</td><td>Biology</td><td>Gamified learning course</td></tr><tr><td>20.</td><td>Jones et al. [123]</td><td>Secondary</td><td>Biology</td><td>Webaed ganifie platform</td></tr><tr><td>21.</td><td>Erdogdu and Karatas [124]</td><td>Primary</td><td>Natural sciences</td><td> Self-developed gamification application</td></tr><tr><td>22.</td><td>Purba et al. [125]</td><td> Secondary</td><td>Chemistry</td><td>Webasedgamife praform</td></tr><tr><td>23.</td><td>Asa&#x27;d and Gunn [126]</td><td>Higher</td><td>Physics</td><td>Webasegaifiedpafom</td></tr><tr><td>24.</td><td>Curto Prieto et al. [127]</td><td> Secondary</td><td>Natural Sciences</td><td>Web-basedganife patfom</td></tr></table></body></html>

A systematic keyword search was used to collect data across all studies while preserving their credibility. To ensure the convergence and verification of our findings, we lastly conducted a document analysis, completing our triangulation procedure. The following essential information was extracted from each article:

1. (a) education level;   
2. (b) content area;   
3. (c) educational context;   
4. (d) methods;   
5. (e) learning theories/models;   
6. (f) outcomes;   
7. (g) findings;   
8. (h) gaming elements;   
9. (i) assessment tools.

# 5. Findings

Before analyzing the primary research objectives, we extracted the top 3 keywords in the 24 studies to glimpse the main themes discussed and analyzed. The top three keywords were “gamification”, “science education”, and “motivation.” These initial findings hinted that the main concern behind gamification in science education is its relation to motivational aspects.

# 5.1. Methodology and Assessment Tools

This section assesses the methodological approaches utilized in the 24 studies we included in our systematic review and the assessment tools used to collect the data. Most of the studies were found to use a mixed-method approach (16), some utilized a quantitative approach (7), and the only one used a qualitative approach (Table 4) solely. The vast majority of research was quantitative and mixed method is essential for the studies’ findings due to quantitative methods [128,129]. Moreover, the large number of mixed result studies are significant as they can provide us a better understanding of their findings and the reason behind them, for instance, by triangulating one set of results with another and thereby connecting micro and macro domains and improving the validity of their conclusions [129,130].

Table 4. Methodology and data collection instrument in studies.   

<html><body><table><tr><td>No.</td><td>Author(s)</td><td>Method</td><td>Data Collection Instrument</td></tr><tr><td>1</td><td>Sanchez-Martin et al. [105]</td><td>Quantitative</td><td>Game records</td></tr><tr><td>2</td><td>Bjaelde et al. [106]</td><td>Mixed methods</td><td>Test evaluations and questionnaires</td></tr><tr><td>3.</td><td>anchezRiva Palmer</td><td> Quantitative</td><td>Questionnaires</td></tr><tr><td>4</td><td>Fleischmann and Ariel [108]</td><td>Mixed methods</td><td>Questionnaires</td></tr><tr><td>5.</td><td>López Carillo, et al. [109]</td><td>Mixed methods</td><td>Game records and questionnaires</td></tr><tr><td>6.</td><td>Sahin and Namli,[110]</td><td>Quantitative</td><td>Test evaluations</td></tr><tr><td>7</td><td>Sanmugam et al. [111]</td><td>Mixed methods</td><td>Test evaluations and interviews</td></tr><tr><td>8</td><td>Khan et al. [112]</td><td>Mixed methods</td><td>Observation and test evaluations</td></tr><tr><td>9.</td><td>Zamora-Polo et al. [113]</td><td>Mixed methods</td><td>Questionnaires and interviews</td></tr><tr><td>10.</td><td>Yapici and Karakoyun [114]</td><td>Mixed methods</td><td>Questionnaires and interviews</td></tr><tr><td>11.</td><td>Lai and Foon [115]</td><td>Mixed methods</td><td>Game records, test evaluations, questionnaires, and interviews</td></tr><tr><td>12.</td><td>Tsai [82]</td><td>Mixed methods</td><td>Test evaluations and questionnaires</td></tr></table></body></html>

Table 4. Cont.   

<html><body><table><tr><td>No.</td><td>Author(s)</td><td>Method</td><td>Data Collection Instrument</td></tr><tr><td>13.</td><td>Pesare et al. [116]</td><td>Quantitative</td><td>Test evaluations</td></tr><tr><td>14.</td><td>Jenkins and Mason [117]</td><td> Quantitative</td><td>Game records and test evaluations</td></tr><tr><td>15.</td><td>Fan and Xiao [118]</td><td> Mixed methods</td><td>Test evaluations,questionnaires,and interviews</td></tr><tr><td>16.</td><td>Hursen &amp; Bas [119]</td><td>Mixed methods</td><td>Test evaluations, questionnaires, and interviews</td></tr><tr><td>17.</td><td>Bonde et al. [120]</td><td> Quantitative</td><td>Test evaluations and questionnaires</td></tr><tr><td>18.</td><td>Kingsley and Melissa [121]</td><td>Mixed methods</td><td>Obseratioe</td></tr><tr><td>19.</td><td>Owens [122]</td><td>Mixed methods</td><td>Questionnaires</td></tr><tr><td>20.</td><td>Jones et al. [123]</td><td>Mixed methods</td><td>Questionnaires</td></tr><tr><td>21.</td><td>Erdogdu and Karatas [124]</td><td>Mixed methods</td><td>Observation, questionnaires, and interviews</td></tr><tr><td>22.</td><td>Purba et al. [125]</td><td> Qualitative</td><td>Questionnaires and interviews</td></tr><tr><td>23.</td><td>Asa&#x27;d and Gunn [126]</td><td>Mixed methods</td><td>Questionnaires</td></tr><tr><td>24.</td><td>Curto Prieto et al. [127]</td><td>Quantitative</td><td>Questionnaires</td></tr></table></body></html>

The data collected revealed some similarities regarding the procedures that were followed and the way they were retrieved. Tests and survey questionnaires were the primary data source tools utilized in the quantitative methodology approach, whereaslowed and the way they were retrieved. Tests and survey questionnaires were the mixed-methods approach studies also included interviews and observation forms. The soledata source tools utilized in the quantitative methodology approach, whereas study that adopted a qualitative approach collected their data through questionnaires andmethods approach studies also included interviews and observation forms. The so interviews.

Apart from the data tools mentioned above, some quantitative and mixed-methodviews. approach studies were also found collecting and using data from the gamification appli-Apart from the data tools mentioned above, some quantitative and mixedcation/platform. In most cases that this was noticed (4), the studies made use of userapproach studies were also found collecting and using data from the gamificatio input and feedback from the gamification application/platform, like score in quizzes [115]cation/platform. In most cases that this was noticed (4), the studies made use of us reports [109] or time spent in the application [121], in conjunction with other stereotypicaland feedback from the gamification application/platform, like score in quizzes [ assessment tools. One study [105] was found to collect and analyze information collectedports [109] or time spent in the application [121], in conjunction with other stere from the application/platform like score points and game index (Figure 2).

![](images/04e50c2a27c94918ae0615cb92b6531ca44880d873b2935f7f41a7c9235a85b9.jpg)  
Figure 2. Percentage of data collectioFigure 2. Percentage of data collection origin in studies.

Concerning the data collection techniques, in all studies, data were collected from multiple sources. The most common tool used was the questionnaires (18), followed by assessments and tests (11), interviews (9) and observations (3), and game index and records1, 11, x FOR PEER REVIEW (5) and observation (3) (Figure 3).

![](images/4d17e2cb4b7f2ae8cb53897da55ad7460e44bf7ca3bf2f539c566a65e4c1f144.jpg)  
Figure 3. The frequency of data collection techniques iFigure 3. The frequency of data collection techniques in all studies.

5.2. Content Area, Educational Levels, and Educational Context

higher education (10) or secondary education (9). The number of articles focusedAccording to the data collected (Table 3), most of the studies involved students from mary education was lower, but still a considerable amount (5). Furthermore, thigher education (10) or secondary education (9). The number of articles focused on prishows that eight studies were related to biology or health concepts, five with phymary education was lower, but still a considerable amount (5). Furthermore, that data cepts, two with chemistry, and none with several scientific concepts of Natural Sshows that eight studies were related to biology or health concepts, five with physics like biology, geology, physics, and chemistry [127] (Table 3). The primary objectivconcepts, two with chemistry, and nine with several scientific concepts of Natural Sciences, ence Education is scientific literacy [131]. However, science education took a newlike biology, geology, physics, and chemistry [127] (Table 3). The primary objective of recent years, as researchers and educators recognized the need to encourage chScience Education is scientific literacy [131]. However, science education took a new turn in recent years, as researchers and educators recognized the need to encourage children’s creative explorations and draw children’s attention to the social dimension of knowledge [132]. The interpretation of the world around us depends on applying and understanding several cepts have trouble students of all educational levels throughout the years [134,13different scientific concepts and methods [133], highlighting the importance of linking teachers [136]? Students often exhibit misconceptions about concepts relative to tconcepts from different scientific fields. What is more, physics and biology concepts tremely resistant to change [134,137], increasing the importance of studies relhave trouble students of all educational levels throughout the years [134,135], even teachthem. Additionally, according to Figure 4, all gamified activities were digital gers [136]? Students often exhibit misconceptions about concepts relative to those extremely applications apart from one [122] that used various gaming elements to gamify aresistant to change [134,137], increasing the importance of studies relating to them. Additory course. Some studies used a pre-existed gamified platform (10) to prompt stionally, according to Figure 4, all gamified activities were digital gamified applications motivation, engagement, ubiquitous and personal learning, promote their social aapart from one [122] that used various gaming elements to gamify a laboratory course. nitive skills, and assist them in pre or post-lecture questions [113] and assess their lSome studies used a pre-existed gamified platform (10) to prompt students’ motivation, achievements. According to Table 3, the most common pre-existed gamified platfoengagement, ubiquitous and personal learning, promote their social and cognitive skills, was used was “Kahoot.” However, other platforms were also utilized, sand assist them in pre or post-lecture questions [113] and assess their learning achievements. According to Table 3, the most common pre-existed gamified platform that was used was “Kahoot.” However, other platforms were also utilized, such as “ClassDojo”, attitudinal competencies [109]. The rest of the studies (nine) developed their digi“Socrative”, “Quizziz”, “Zondle”, and “3D GameLab”. Other articles developed or used ification applications to help students test and consolidate their knowledge, supppre-existed gamified simulations (four) to support students’ learning and broaden and learning [109], promote students learning performance and engagement [116,1develop students’ conceptual, procedural, and attitudinal competencies [109]. The rest of assist them in their learning assessment [107]. The high number of self-developedthe studies (nine) developed their digital gamification applications to help students test cation applications indicates that integrating game elements in a software develand consolidate their knowledge, support their learning [109], promote students learning performance and engagement [116,117], and assist them in their learning assessment [107].

The high number of self-developed gamification applications indicates that integrating1, 11, x FOR PEER REVIEW game elements in a software development process has become relatively easier [138], especially considering the increasing number of Web 2.0 tools that can integrate game elements into existing platforms [139].

![](images/9e78176ac63ceaccc4f6a28af67ced6e7dd9c9fff20b463269de85d34ee9fce8.jpg)  
Figure 4. Percentage of gamified enviroFigure 4. Percentage of gamified environments in studies.

# 5.3. Theories Underpinning Gamification and Ga5.3. Theories Underpinning Gamification and Game Elements

Underlying theoretical models play a big part in designing a gamification appUnderlying theoretical models play a big part in designing a gamification application concerning game elements. To correlate game design elements and mechanics outcomes, it is crucial to understand the underlying motivational processes that frame cognitive and behavioral changes, namely the learning theories [4]. Thus, we conducted this analysis to depict the theoretical models’ current state in gamification research in science education. rate on the theoretical content or theory they were based on. Apart from the sixAs shown in Table 5, most of the articles we used in our systematic review did not elaborate that make implicit mentions of their theory they are based on, the rest (18) menton the theoretical content or theory they were based on. Apart from the six articles that importance of motivational aspects, like intrinsic or extrinsic motivations, and thmake implicit mentions of their theory they are based on, the rest (18) mentions the imporbut do not establish a conceptual framework on a theoretical foundation. For insttance of motivational aspects, like intrinsic or extrinsic motivations, and their role, but do Yapici and Karakoyun [114], students’ motivational aspects, intrinsic and extrinsnot establish a conceptual framework on a theoretical foundation. For instance, in Yapici vation, are highlighted and explained. However, it is difficult to understand theand Karakoyun [114], students’ motivational aspects, intrinsic and extrinsic motivation, rewards and interpretation of the players’ motivations for engaging and playing are highlighted and explained. However, it is difficult to understand the role of rewards carefully designing and crafting specific game elements, mechanics, and functionand interpretation of the players’ motivations for engaging and playing without carefully designing and crafting specific game elements, mechanics, and functions linked to a theoretical model [21,140]. Of the six articles that used a theoretical framework, it was noted that the self-determination theory (SDT) was adopted two times. SDT has been one of the chological needs to game design elements giving valuable insight on the connecmost comprehensive and noticeable theories in gamification research [26] as not only it tween game elements, motivational aspects, and results and learning outcomes [1explains and links extrinsic and intrinsic motivation but also match the core psychological instance, in Owens [122], repeat testing was associated with increased intrinsic needs to game design elements giving valuable insight on the connection between game tion, competence, score, and learning comprehension. Moreover, in Erdogdu and elements, motivational aspects, and results and learning outcomes [141]. For instance, [124], badges were linked with the sole augmentation of extrinsic motivation and in Owens [122], repeat testing was associated with increased intrinsic motivation, compement results.tence, score, and learning comprehension. Moreover, in Erdogdu and Karatas [124], badges were linked with the sole augmentation of extrinsic motivation and achievement results.

Table 5. Theoretical models, Game elements and learning outcomes.   

<html><body><table><tr><td>Articles</td><td> Theories Underpinning Gamification</td><td>Game Elements</td><td></td><td>Learning Results</td><td>Motivational Outcomes</td></tr><tr><td> Sanchez-Martin et al. [105]</td><td> Dots otclearly eadbatee</td><td></td><td>：。</td><td></td><td></td></tr><tr><td>Bjaelde et al. [106]</td><td> Does not clearly elaborate on</td><td>Levels,leaderboards,</td><td>：</td><td>Low and high-grade students have better results. Some students get too focused</td><td>： Increased motivation for</td></tr><tr><td></td><td> motivational aspects.</td><td>competition.</td><td>their results.</td><td> op theanfiashindering</td><td> learning.</td></tr><tr><td>Sanchez-Rivas, Ruiz-Palmero and Sanchez-Rodriguez [107]</td><td>Does not clearly elaborate on motivational aspects.</td><td>Competition, points, leaderboards, prizes.</td><td></td><td>The application of gamified examinations improves teachers&#x27; perception of their students&#x27;motivation towards</td><td>High levels of motivation during a gamified evaluation.</td></tr><tr><td>Fleischmann and Ariel [108]</td><td></td><td></td><td>：</td><td>assessment tests. Enaifiresiiiseie</td><td></td></tr><tr><td>López Carrillo et al. [109]</td><td></td><td></td><td>：</td><td>Increase awareness of students and teachers&#x27; achievements</td><td></td></tr><tr><td></td><td></td><td> Puzzle, score,levels/misions,</td><td>：</td><td>their skills for their future professional development.</td><td></td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>Articles</td><td>Theories Underpinning Gamification</td><td>Game Elements</td><td>Learning Results Increased achievement level</td><td>and students&#x27;test scores.</td><td>Motivational Outcomes</td></tr><tr><td> Sanmugam et al. [111]</td><td>Dotiv ot aeal elaborah on</td><td>Pointseertiv</td><td>. the learning process.</td><td>Some game elements helped change students&#x27; perspective weithdot (points and leaderboards). Importance of internet speed and computer equipment in</td><td> It is not specified.</td></tr><tr><td> Khan et al. [112]</td><td>Does not clearly elaborate on motivational aspects.</td><td>edacspints iat gnals/bjectivspreson</td><td></td><td>No significant learning Ntequalyeffectie fo all</td><td>Positive influence on student Notequalyeffectiefo all bsyentseincilsomrtorm</td></tr><tr><td>Zamora-Polo et al. [113]</td><td>Does not clearly elaborate on motivational aspects.</td><td>Narrative,levels, competitive and cooperation activities, points.</td><td></td><td>An acknowledgment of acceptable teaching practices.</td><td>Increase in the students&#x27; motivation levels Clear enhancement of positive emotions toward science teaching. Increased motivation levels after</td></tr><tr><td>Yapici and Karakoyun [114]</td><td> Dotivatclearly eabrate on</td><td>Quiz, time-pressure, points, leaderboard competitive,</td><td>.</td><td>A low score in scoreboards and .</td><td>the application process Mostly reported positive opinions aouthe taotoalicsfuture utilization of Web-based Gamified platform.</td></tr><tr><td>Lai and Foon [115]</td><td>Does not clearly elaborate on motivational aspects.</td><td>Leaderboard, levels, competitive.</td><td>.</td><td>Self-directed learning and in-depth lerning were Students had increased learning achievements.</td><td>learning Physics.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>Articles</td><td> Theories Underpinning Gamification</td><td>Game Elements</td><td>Learning Results Acquisition of science</td><td></td><td>Motivational Outcomes</td></tr><tr><td>Tsai [82]</td><td>Flow theory.</td><td>Strytimedpitsreards</td><td>knowledge improved Participants&#x27; performance proved a gradualdelining Points is a highly potential gamified element.</td><td>.</td><td> Students displayed positive</td></tr><tr><td>Pesare et al. [116]</td><td></td><td></td><td> It is not specified.</td><td></td><td>nanced stuents motiafi</td></tr><tr><td> Jenkins and Mason [117]</td><td>Doesat lealy elabort on</td><td> Time-presr,. els</td><td>Positive correlations between</td><td></td><td> Increased engagement.</td></tr><tr><td>Fan and Xiao [118]</td><td> Dotivtlearly eaatee</td><td></td><td>meaningful learming and learning outcomes. learning achievement. Increased learning</td><td></td><td>·It is not specified.</td></tr><tr><td>Hursen and Bas [119]</td><td>Doevatclealy elabort on</td><td>Avatar, cooperative and cedetiiritsde progression.</td><td>Increased performance, caommupieaton.</td><td></td><td>Increased motivation towards doing research Stuiveoppsnthe usage f gamification in science education.</td></tr><tr><td>Bonde et al. [120]</td><td>Cognitive theories of multimedia learning</td><td> torytelling ainahions</td><td>Improved learning outcomes It significantly improved leambiningthomemified laboratory simulation with traditional teaching.</td><td></td><td>Imiedotimlsing</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>Articles</td><td>Theories Underpinning Gamification</td><td> Game Elements</td><td> Learning Results</td><td>Motivational Outcomes</td></tr><tr><td> Kingsley and Melissa [121]</td><td>Mltifcte</td><td> ss</td><td>Improvel studets aesi</td><td>. Improved students&#x27; enjoyment the activity</td></tr><tr><td>Owens [122]</td><td> Self-determination.</td><td>： Repeatesting adges,</td><td>Students in gamified environments to repeat-testing had inceceadlaning comprehension.</td><td>. Gaming elements increased student achievement-goal orientation and motivation to learn. Repeatpengsiedtht intrinsic interest and a personal desire to enhance one&#x27;s understanding.</td></tr><tr><td> Jones et al. [123]</td><td></td><td></td><td> It is not specified.</td><td>Increase engagement, enjoyment, andetheomopleientfie desirable/manageable.</td></tr><tr><td>Erdogdu and Karatas [124]</td><td>Self-determination theory.</td><td> Puizzeetsdear</td><td> environment among the</td><td>.。 motivation.</td></tr><tr><td>Purba et al. [125]</td><td>Theory of motivation to learn.</td><td>Quizzes,collaboration, ： competition,leaderboards</td><td> It is not specified.</td><td>： Web-based Gamified platform increases motivation to learn chemistry.</td></tr><tr><td> Asa&#x27;d and Gunn [126]</td><td>Does not clearly elaborate on motivational aspects.</td><td>Competition, progression, leaderboards</td><td> It is not specified.</td><td>：</td></tr><tr><td>Curto Prieto et al. [127]</td><td>Dotsvatocnlaly elaborateon</td><td> outeration pgresion</td><td></td><td>home. It is not specified.</td></tr></table></body></html>

Other theories included flow theory, goal-setting theory, cognitive theory of multimedia learning, and motivation theory to learn. According to Zainuddin et al. [15], flow theory1, 11, x FOR PEER REVIEW 18 of 37 and goal-setting theory are more common in gamification research. The former emphasizes internal processes to maximize engagement and learning by balancing challenges with skill level and utilizing appropriate game elements that optimize the students’ experi-Other theories included flow theory, goal-setting theory, cognitive theory of multience [70,142]. The latter focuses on introducing viable long-term and short-term objectivesmedia learning, and motivation theory to learn. According to Zainuddin et al. [15], flow that students consciously strive to attain [45] while using game elements to direct learners’theory and goal-setting theory are more common in gamification research. The former attention to targeted learning activities [47]. Even though only a small number of studieslenges with skill level and utilizing appropriate game elements that optimize the students’ implemented a theoretical framework behind the gamification application development,experience [70,142]. The latter focuses on introducing viable long-term and short-term oball of those studies reported increased learning results, motivational outcomes, or both.jectives that students consciously strive to attain [45] while using game elements to direct

Gamification involves identifying and applying either single or limited combinations of studies implemented a theoretical framework behind the gamification application deof game design elements [143]. Due to the core value the game elements and mechanicsvelopment, all of those studies reported increased learning results, motivational outhave in a gamified environment and the mixed results in an educational setting, many re-comes, or both. searchers have suggested a connection between the game elements and the learning outcomes [34,144]. Consequently, reviewing the main game elements and mechanics used inhave in a gamified environment and the mixed results in an educational setting, many gamified environments is vital. According to Table 5, where all game elements are listedresearchers have suggested a connection between the game elements and the learning for each game, and to Figure 5, that analysis charts the percentages of the game elements inoutcomes [34,144]. Consequently, reviewing the main game elements and mechanics used total, we found out that the game elements and mechanics that were most commonly usedfor each game, and to Figure 5, that analysis charts the percentages of the game elements in gamified environments in science education were a competition set up, leaderboards,in total, we found out that the game elements and mechanics that were most commonly points, and levels.used i

![](images/10a7b7ec80a04904a28351a09bcb88848a4305fc731d5f029fba2773c66b3247.jpg)  
Figure 5. The frequency of game elements used in the studies.

ment. Despite its controversy, competitive environments can increase motivation, incite Those top four elements are all consistent in creating a more competitive environment. dedication in the learning process, and create an enjoyable learning environment [145]. Despite its controversy, competitive environments can increase motivation, incite dedicaAccording to Glover [146], competitiveness in a gamified setting positively affects stu-tion in the learning process, and create an enjoyable learning environment [145]. According The competitive environment inside the gamified environment favors developing to Glover [146], competitiveness in a gamified setting positively affects students’ behavior metacognitive abilities, empathy, and promoting teamwork [147]. In Joand helps them overcome negative attitudes towards competition.

gamification application "KAHOOT” is specifically chosen for its competitive nature, The competitive environment inside the gamified environment favors developing and engagement” even in subjects that students face difficulties, like biology. That being metacognitive abilities, empathy, and promoting teamwork [147]. In Jones et al. [123], the gamification application "KAHOOT” is specifically chosen for its competitive nature, which is not up to the point of being unpleasant, that can “accentuates student motivation and engagement” even in subjects that students face difficulties, like biology. That being said, game elements, like competition and leader board, have also been found to pose a certain number of hindrances in learning, like maintaining students’ motivation and engagement [148,149].

# 5.4. Gamification’ Learning and Motivational Outcomes

Gamification learning outcomes have produced mixed results over the years, creating controversy and doubts over its potential in education [91,150]. Therefore, it is crucial to analyze the effects of gamification in science education. During our investigation of the 24 studies included in the systematic review, three outcomes were highlighted: motivation and engagement, learning achievements, and social interaction. Moreover, some inefficient outcomes were also noted and analyzed (Table 5). Even though some studies did not measure gamification’s impact on motivation [108,110,111,118,127], all other studies showed a general increase in motivational outcomes indicating the possible positive affordances have when implemented in a school set up.

Gaming elements are the main gamification tools that affect students’ motivation, engagement, and learning experiences [25,26]. However, points and leaderboards, two quite common game components in our research (Figure 5), despite displaying positive effects on learners’ engagement, have also been criticized for only providing extrinsic motivation. These findings are in line with researchers Erdogdu and Karatas [124], who discovered that although their external students’ motivation significantly increased, their intrinsic did not. Nonetheless, gamification is often characterized by fostering enthusiasm, a sense of enjoyment, fun, and general positive feelings towards learning, values that are directly associated with intrinsic motivation [59,82,114]. Consequently, acknowledging only one motivational aspect or considering one without the other will only give an incomplete picture [151]. Both extrinsic and intrinsic motivations are part of gamification and have a vital part in students’ learning experience by fulfilling their basic needs: competence, autonomy, and relatedness. As SDT correlates, both extrinsic and intrinsic motivations intercede and have common properties among them [152]. Based on our analysis, motivation and engagement are directly linked to enhancing and understanding scientific concepts and generally improved learning outcomes [108,119]. According to Table 5, all studies that displayed an increase in intrinsic motivation [113,114,119,121,123] (positive emotions, enjoyment), even when utilizing extrinsic related elements (e.g., leaderboards, points) also reported increased motivation, engagement and learning outcomes. Students’ positive attitudes and support of their autonomy can also promote meaningful learning experiences [115,118] and support their skills [109].

Gamification research has been heavily baffled about the potential it can encompass regarding students learning achievements. As it is shown in Figure 6, from the 13 studies that investigated the learning results of the students, only 2 studies reported insignificant results. These findings are extremely important as they indicate the positive impact gamification can have on the students learning achievements. Nevertheless, although gamified concepts embedded in gamified environments have been found to increase students’ learning performance, they often are characterized by short-term and immediate effects [20]. The integration of gamification into contemporary pedagogical learning strategies, such as flipping, inquiry-based or meaningful learning, could be an alternative and effective strategy to increase students’ learning outcomes for the long-run [47,115,117] as several studies that had increased academic results integrated such strategies [108,117,120,122]. A correlation between increased motivation, engagement, and academic results were noticed [82,105,117,120–122]. According to Table 5, all studies that measured both learning and motivational outcomes and reported increased learning results also noted enhanced motivation, positive feelings, or influenced in a right way learning-related behaviors, like engagement.

Consequently, our results indicate a strong connection between improved motivational outcomes and significant learning results. This result is consistent with previous studies that the more motivated and engaged a student is, the more likely to achieve more significant learning results [153,154]. Of course, not all studies that displayed better motivational outcomes also reported better learning achievements. Though in some of these cases, factors related to bad game design [106] or unpreparedness of students to utilize the gamification application [114] were highlighted, others did not identify a possible reason behind this result [112]. Furthermore, social interaction is an essential part of a gamification application, with many studies highlighting that game elements assist students’ social interaction [105]. This realization is more distinctive while considering that the introduction of competitiveness, points, and leaderboards were three of the most found game elements noted in our systematic review. As many researchers have pointed out, gamification also possesses limitations and barriers that hinder the learning process.

![](images/08ecb4fc038e7d9dafff3eedc93e396678221a723e06ac08cbd0284cde781940.jpg)  
Figure 6. Percentage of learning reFigure 6. Percentage of learning results in studies.

tional outcomes and significant learning results. This result is consistent with previous As it is shown in the study of Sanmugam et al. [111], gaming elements can create studies that the more motivated and engaged a student is, the more likely to achieve more different perspectives in the learning process, some beneficial (Badges) and others not significant learning results [153,154]. Of course, not all studies that displayed better moti-(points and Leaderboard), indicating that the mere use of gaming elements may not provide vational outcomes also reported better learning achievements. Though in some of these the desirable results. Matching learning with individuals objectives and challenges and creating a flow between extrinsic motivation factors and intrinsic motivation could help son behind this result [112]. Furthermore, social interaction is an essential part of a gami-teachers select the proper game mechanics suited to their gamified environment [15] and fication application, with many studies highlighting that game elements assist students’avoid undesirable effects, like in the study of Sanchez-Martin et al. [105], where students social interaction [105]. This realization is more distinctive while considering that the in-could not understand the benefits of working together instead of bidding against each other.

troduction of competitiveness, points, and leaderboards were three of the most found Moreover, theoretical motivational frameworks and learning strategies are crucial to gamification also possesses limitations and barriers that hinder the learning process.properly steer and produce experiences meaningful to the students and result in positive As it is shown in the study of Sanmugam et al. [111], gaming elements can create learning outcomes [4,155], which is often rare in gamification research [156]. What is different perspectives in the learning process, some beneficial (Badges) and others not more, technical issues can heavily negatively influence the learning experience. As re(points and Leaderboard), indicating that the mere use of gaming elements may not pro-ported in the research of Sanmugam et al. [111], problems associated with internet speed and creating a flow between extrinsic motivation factors and intrinsic motivation could and computer equipment can heavily influence the learning process, creating negative help teachers select the proper game mechanics suited to their gamified environment [15]feelings. Proper preparation is also vital since insufficient technological skills can negaand avoid undesirable effects, like in the study of Sanchez-Martin et al. [105], where stu-tively affect the learning process and produce lower academic results, as in Yapici and dents could noKarakoyun [114] research.

# 6. Discussion

# learning outcomes [4,16.1. Key Findings and Implications

technical issues can heavily negatively influence the learning experience. As reported in This systematic review was conducted to provide an overview and insight into the research literature regarding gamification in science education. Though gamification Proper preparation is also vital since insufficient technological skills can negatively affect research has been a relevant new subject in education, valuable information can be extracted the learning process and produce lower academic results, as in Yapici and Karakoyun on its current state of science education and possible guidelines and directions for future [114] resresearch on this topic.

Our literature review revealed a more significant utilization in secondary and higher education than primary education regarding gamification in science education at different educational levels. This is consistent with other recent literature reviews that suggest that the gap in studies between higher and primary and secondary education is closing [59]. Nonetheless, the primary education studies were significantly less than the other two. This could be explained by the fact that Science Education is more restricted in primary education than Language and Math. Apart from Natural Sciences, which include different scientific fields, biology and physics have been the premium content areas for most gamification applications. Physics and biology concepts are challenging for students to grasp, and very often, students present misconceptions about them [134,137]. However, gamification seems to have restrictions regarding the content it is implemented and should not be regarded as a universal tool for all content in the curriculum [9,74]. As such, it would be beneficial for future research to explore more thoroughly other content areas too to clarify gamification’s potential, affordances, and link with the whole spectrum of science education.

Furthermore, though pre-existing platforms have been used extensively in science education, many studies utilized self-developed gamification applications. One of the significant obstacles regarding integrating game-based learning and ICT into learning has been the generally high cost for development [56]. The high number of studies utilizing self-developed gamification applications show how much easier the development of such application has become and, more importantly, the gaming elements’ role and the need to design and personalize the gamification application.

The analysis in this study also gave us valuable insight into the use of specific assessment tools and how data are gathered and used. Though most of the studies extracted data with conventional means, like questionnaires, interviews, and tests, some research studies also utilized data gathered through the gamification application. Gamification applications and new interactive smart screen technologies have the potential to provide us with immediate and useful feedback, which can enhance and supports researchers’ findings, like game score, final assessments, or time spent engaged in the activity. In this way, researchers do not have to monitor the whole procedure continually, and students are relieved from the anxiety they are being assessed [107,121,157]. The students themselves produce information about their learning progress and requirements, allowing teachers and researchers to gather user-specific data that are more thorough and multidimensional during a “non-invasive form” of assessment [87,89]. Gamification application could also support other profound ways of assessment that could give insights to researchers that conventional means cannot, like eye-tracking, motion tracking, or mouse tracking, as it could give high- accuracy and detailed record of student’s movements, tendencies, way of thinking and general learning progress [158–160]. Furthermore, most of the studies followed a quantitative and mixed methods approach, strengthening the validity of their findings and conclusions based on the data gathered [130].

Regarding game elements implemented in gamified environments in science education, we discovered a competition, leaderboards, points, and levels where the most common mechanics used. The competitive environments and game elements, like leaderboards and points, have been met with many controversies, of whether it increases enjoyment [116] or diminished it [105]. In our study, findings show that the majority of the research articles display positive attitudes and learning outcomes, consistent with findings from other studies [147]. Despite this, a large portion of research has focused on competition, leaderboards, points, and badges [144,161], leaving various types of other gaming elements that show great potential, like avatars, storytelling, and quizzes, with limited exposure and without a clear insight of their potential [110,119,120].

Though a small proportion of articles established an underlying theory model to depict the motivational processes that lead to cognitive and behavioral changes, most of the articles failed to elaborate on the theoretical model they were based on. The motivation was one of the most used keywords in the articles that were analyzed, and even though all articles mentioned the importance of motivational aspects, the majority of the studies had no clear theoretical principle making it extremely difficult to interpret the connection between players motivation for engaging, game mechanics role and the learning outcomes [88]. Though not all of the studies that incorporated a theoretical framework reported both motivational and learning outcomes, they all supported that gamification can positively influence students’ learning. The studies that reported both motivational and learning results provided valuable insight into the aspects of motivation, intrinsic and extrinsic, that were enhanced. Especially in the studies based on the self-determination theory, the affected motivational aspect was transparent [122,124]. Unfortunately, due to the lack of studies utilizing a theoretical framework for the design of their gamification application, a connection between an element or set of them with a specific motivational aspect, like in the case of Erdogdu and Karatas [124] where badges were found to only increase external motivation, cannot be generalized. Thus, consistent with previous studies, further work must be conducted to address the lack of theory in the gamified instructional frameworks [4,24]. According to [56], the general disregard of gamified instructional frameworks and the widespread use of competitive environments and PBL (points-badges-ladders) results from 21st-century education policy and corporate exigencies to introduce gamification into learning. In this way, gamification is mainly regarded as an enactment, and reinforcement tool of neoliberal and market logic meant to bridge the students’ satisfaction and content curriculum, portraying learning as pedagogically progressive and inherently fun. However, it tries to reorganize learning around measurable rewards systems and competition offering little autonomy and flexibility. Students are meant to be continuously supervised to measure their performance and continuously compete with each other as a way to increase their productivity [162]. The dominant presence of competition and PBL game elements, even in our SLR, implies a more goal orientated and reward/points accumulation approach consistent with the promotion of a neoliberal learning agenda [56] and arguably shares common attributes with rote learning and memorization [163].

Nonetheless, gamification can incorporate authentic pedagogical models [164] that differentiate from the established neoliberal and market logic. Most studies that explore theoretical foundations in gamification are mainly focusing on self-determination theory, flow, or goal-setting theory that concentrates on motivational affordances that instantiate gameful experience, beneficial for learning [156,165]. As science education highlights students’ creative exploration and social dimension, it is exceptionally crucial to investigate theoretical frameworks and designs in gamification that adhere to this aim and each person’s different needs, values, and interests [166,167].

Regarding the contradictory results [66,150] that we discussed in the introduction, our literature review based on our findings [82,105,109,117,120–122] suggests that the use of gamified environments and the creation of could positively affect students’ motivational outcomes, creating positive learning-related attitudes, like engagement, and leading to significant learning achievements. Specifically, there is some evidence which indicates that the combination of intrinsic motivation, like enjoyment, enthusiasm, and fun, in combination with external rewards, can affect the acquisition of skills, competence, and improving the understanding of scientific concepts [88,125]. Additionally, the present study results indicate that gamification in science education can positively impact students’ academic results [15,59], and games are inherently entertaining and enjoyable for students. Our findings also suggest that the use of gaming elements such as levels, points, leaderboards, and competition environment, can not only promote students’ extrinsic motivation but also positively affects students’ behavior and increase their intrinsic motivation even in subjects and concepts that students have difficulty in understanding [123]. However, an intrinsically motivated student will be more willing to participate and commit extensively to the learning materials and teaching process [15]. Nevertheless, since many of the studies we included in this SLR did not investigate or specify students’ learning results, we cannot generalize them.

Moreover, regarding the ad hoc use of gaming elements, our literature review showed that in gamification in science education, game elements that are designed to affect both intrinsic and extrinsic motivations, along with the integration of contemporary pedagogical learning strategies, like inquiry-based or flipped learning, have shown promising results towards the increase of students’ learning achievements [117,122]. Consequently, it is suggested that a well-designed gamification application, carefully implementing gaming elements and mechanics based on an underlying theory, combined with pedagogical learning strategies, can increase motivational outcomes, and possibly result in improved academic results. All limitations and problems related to gamification were found to be the result of students having different objectives than the ones that were set, not being able to follow up with the challenges, technical issues, or unpreparedness to use the gamified environment, which could mean a lack of gaming or digital literacy, or multi-modal literacy and learning [56]. Gamification does assume a certain level of digital literacy and access to digital and gaming technologies for its efficaciousness as lack of gaming skills can easily lead to student disengagement [56,168].

# 6.2. Limitations

Despite our efforts, there are several limitations and threats to the validity of our review. As only 24 articles were eligible for inclusion, a small number, more research will be necessary to fully understand the scope and potential of gamification in science education. In general, gamification research has been primarily focused on computer science implementation rather than other topics, such as mathematics or science education. Although an increase in literature in science education was noted, as half (12) of the articles we reviewed were only two years old (Table A1), a more significant sample of articles could provide more concrete results of gamification impact on students. This sample possibly clarifies gaps related to the importance of theories underpinning gamification, the direct effect each game element has, and the relevance of utilizing more pedagogical learning strategies.

Furthermore, according to Cronin et al. ([100], p. 38) suggestion, we used multiple database searches and did not limit our literature review, but potentially relevant publications could still have been missed due to bias in selecting databases or in the search strings that were used. Future studies could utilize multiple engines in their research, like Google Scholar, such as JCR or Scopus, to mitigate the bias in selecting databases. Moreover, our review is subject to language bias since only English written articles were included [169]. However, to avoid publication bias, this study incorporated and followed some of Kitchenham’s [97] search strategies, including proceedings from conferences and contact with professionals working in the fields for any unpublished literature.

Future researchers should further expand their investigation to include other types of publications that could give more in-depth information and insight, like dissertations and conceptual papers. Though we excluded such types of publications to increase the validity of our research, the novelty of gamification in science education could benefit from more in-depth information as suggested by Moher et al. [170], mostly because research in gamification has been primarily focused in other educational areas, such as computer science [59]. Although we reviewed the assessment tools used in each study, we did not analyze the user data analysis procedures. Another considerable limitation in our review is the small number of cases in some of our categories. Specifically, the small number of studies that included the theoretical framework limits the generalizability of our results.

Moreover, not all content areas of science education were equally investigated. We did not consider the characteristics and demographics of the samples utilized in the studies we included in this review. Such data have been found to affect gamification experiences [53,54], which also affects the generalizability of our findings. Additionally, it was noted that all studies included in this review had a short-term format. Longitudinal studies are necessary to understand and solidify the efficacy of gamification in students’ knowledge acquisition. Another critical threat to the validity is that in this study, a single reviewer, the author, conducted the paper and review selection. Generally, it is advised that a minimum of two different reviewers should separately organize and carry out their review of titles, abstracts, and full papers for exclusion [171]. Nonetheless, following Kitchenham [97] suggestions for a single reviewer, the researcher had contact, discussions, and consultations in regards to the inclusion and exclusion process and the implementation of search strategies with two professional experts with research practice from the Department of Preschool Education at the University of Crete, Greece.

# 7. Conclusions and Future Work

In this study, we conducted a systematic literature review to examine the use of gamification in science education over the eight years from 2012 to mid-2020. The review results gave us valuable insight and enriched the current literature in several ways. First, we augmented our understanding of where and how gamification is applied in science education. We identified the most shared content areas gamification is being integrated, its use of educational levels, and the current trends in gamified environments. Another valuable contribution of this research is the reveal of gamification’s potential to enhance data collection from users in research studies by incorporating new assessment tools.

Gamification can increase the quantity and quality of data, giving more information on the students’ learning process. Furthermore, this study identified the primary gaming elements used currently in science education. Creating a competitive environment is controversial; it is commonly used in science education to combat students’ negative emotions and experiences and increase learning outcomes. The core learning outcomes that were pointed out to be affected the most were motivation and engagement, learning achievements, and social interaction.

The purpose of this study was to depict the current state of the literature on gamification in science education, its potential regarding research and teaching, and the connection between theoretical frameworks, gaming elements, and learning outcomes. The continuous integration of digital and smart technologies in education is a widely noticed phenomenon highlighted in the school curriculum for supporting learning [172,173].

Digital technologies, like gamification, can heavily influence the learning process in content areas related to science education, a field that students often present negative emotions and have difficulties in understanding concepts. From this study, it can be argued that gamification improves the teaching of science education and boosts student motivation, engagement, and learning outcomes. However, this study’s results point out several issues that need to be carefully considered in future studies. Firstly, only small longitudinal studies have been conducted, revealing mixed results [174]. Thus, more studies that research gamification long-term effects are urgently needed to clarify its impact on education.

Further, our findings indicate that gamification applications in different educational levels are diminishing but are still significant. The reason behind this gap in research raises a lot of questions [175]. Are there aspects of gamification that affect some target groups differently, and to what extent? Future research should attempt to address issues that relate to different aspects of gamification, such as educational strategies utilized, game mechanics, and elements. Though we investigated and argued regarding the most used gaming elements in science education, we cannot presume the effects of each gaming element alone since all studies used gaming elements in combinations—some utilized pedagogical learning strategies, which also affect motivation aspects [176]. Therefore, more studies focusing on gaming elements’ direct effects in gamification must clarify the actual effects on motivation outcomes and learning-related behaviors. In addition, more studies must be carried out regarding gamification in science education and students’ learning results to determine the true extent of gamification’s impact.

Moreover, teachers can heavily influence the process of gamification in science education [177]. Some of the studies [109,114] we reviewed were associated with teacher education, and they are prospective in implementing gamified environments in their teachings. Therefore, a review of teachers’ perspectives and teaching strategies they implement in gamification could give valuable information regarding student learning outcomes. Furthermore, it is vital to conduct more studies in under-represented content areas of science education like chemistry or astronomy further to solidify the impact of gamification in science education.

Author Contributions: All co-authors contributed to data collection and/or analysis of project results. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

# Appendix A

Data Availability Statement: The data presented in this study are available on request from the corresponding author.

Conflicts of Interest: The authors declare no conflict of interest.

Table A1. Author(s), year of publication journals, conferences, and methodology.   

<html><body><table><tr><td>Author(s)</td><td>Year of Publication</td><td> Journal</td><td>Methodology</td></tr><tr><td>Sanchez-Martin, et al. [105]</td><td>2017</td><td>Thinking Skills and Creativity</td><td>Quantitative</td></tr><tr><td>Bjaelde et al. [106]</td><td>2014</td><td>World Conference on E-Learning in Corporate, Government, Healthcare, and Higher Education</td><td>Mixed methods</td></tr><tr><td>Sanchez-Rivas, Ruiz-Palmero and Sanchez-Rodriguez [107]</td><td>2018</td><td>Educational Sciences: theory and practice</td><td>Quantitative</td></tr><tr><td>Fleischmann and Ariel [108]</td><td>2016</td><td>Contemporary Educational Technology</td><td>Mixed methods</td></tr><tr><td>López et al. [109]</td><td>2019</td><td>The Electronic Journal of e-Learning</td><td>Mixed methods</td></tr><tr><td> Sahin and Namli, [110]</td><td>2016</td><td>InteatioalJoeesi</td><td> Quantitative</td></tr><tr><td>Sanmugam et al. [111]</td><td>2016</td><td>t</td><td>Mixed methods</td></tr><tr><td>Khan et al. [112]</td><td>2017</td><td>Education and Information Technologies</td><td>Mixed methods</td></tr><tr><td>Zamora-Polo, et al. [113]</td><td>2019</td><td>Education Sciences</td><td>Mixed methods</td></tr><tr><td>Yapici and Karakoyun [114]</td><td>2017</td><td>Turkish Online Journal of Qualitative Inquiry</td><td>Mixed methods</td></tr><tr><td>Lai and Foon [115]</td><td>2019</td><td>Educational Communications and Technology Yearbook (ECTY)</td><td>Mixed methods</td></tr><tr><td>Tsai [82] Pesare et al. [116]</td><td>2018</td><td>Journal of Educational Computing Research</td><td>Mixed methods</td></tr><tr><td>Jenkins and Mason [117]</td><td>2016</td><td> Smart Learning Environments</td><td> Quantitative</td></tr><tr><td></td><td>2020</td><td>Active Learning in College Science</td><td>Quantitative</td></tr><tr><td>Fan and Xiao [118]</td><td>2015</td><td>Eurasiatat&amp;</td><td>Mixed methods</td></tr><tr><td>Hursen and Bas [119]</td><td>2019</td><td>Intereag</td><td>Mixed methods</td></tr><tr><td>Bonde et al. [120]</td><td>2014</td><td>Nature Biotechnology</td><td>Quantitative</td></tr><tr><td>Kingsley and Melissa [121]</td><td>2015</td><td> Journal of Adolescent &amp; Adult Literacy</td><td>Mixed methods</td></tr><tr><td>Owens [122]</td><td>2019</td><td>Evolution Education Re-considered</td><td>Mixed methods</td></tr><tr><td>Jones, et al. [123]</td><td>2019</td><td> Simulation &amp; Gaming</td><td>Mixed methods</td></tr><tr><td>Erdogdu and Karatas [124]</td><td>2016</td><td>2016InteacWoddua</td><td>Mixed methods</td></tr><tr><td>Purba, et al. [125]</td><td>2019</td><td>Pendidikan Kimia</td><td>Qualitative</td></tr><tr><td>Asa&#x27;d and Gunn [126]</td><td>2018</td><td>Physics Education</td><td>Mixed methods</td></tr><tr><td>Curto Prieto et al. [127]</td><td>2019</td><td>Education Sciences</td><td>Quantitative</td></tr></table></body></html>

Table A2. Data sources, search strings, restrictions and adjustments, and articles identified.   

<html><body><table><tr><td>Data Source</td><td>Search Strings (&quot;gamification&quot; OR &quot;gamified&quot;,OR “gamified environment&quot;,OR “gamified</td><td>Restrictions and Adjustments</td><td>Total Articles Identified</td></tr><tr><td>Eric</td><td>application&quot;,OR &quot;applied game design&quot;,) AND(&quot;scientific education&quot; OR &quot;science teaching&quot; OR “teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR “physics&quot; OR &quot;biology&quot; OR &quot;astronomy&quot; OR &quot;natural sciences&quot; OR &quot;earth sciences&quot;) AND(&quot;education&quot; OR &quot;primary education&quot; OR &quot;elementary education&quot; OR &quot;K-12 education&quot; OR “graded school education&quot; OR &quot;secondary education&quot; OR “high school&quot; OR “junior high school&quot; OR &quot;middle school&quot; OR&quot; &quot;prep school&quot; OR &quot;preparatory school&quot; OR &quot;senior high school&quot; OR &quot;college preparatory school&quot; OR &quot;intermediate school&quot; OR &quot;higher education&quot; OR “further education&quot; OR “graduate school education&quot; OR “tertiary-level education&quot; OR &quot;university education&quot;) OR (&quot;gaming elements&quot; OR “gaming mechanics&quot; OR &quot;gaming components&quot; OR &quot;gaming factors&quot; OR &quot;gaming constituent&quot;) (&quot;gamification&quot; OR &quot;gamified&quot;,OR &quot;gamified environment&quot;, OR &quot;gamified application&quot;,OR &quot;applied game design&quot;,) AND (&quot;scientific education&quot; OR &quot;science</td><td>Published since 2012</td><td>74</td></tr><tr><td>Wiley Online Library</td><td>teaching&quot; OR “teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR &quot;physics&quot; OR &quot;biology&quot; OR &quot;astronomy&quot; OR &quot;natural sciences&quot; OR &quot;earth sciences&quot;) AND(&quot;education&quot; OR &quot;primary education&quot; OR &quot;elementary education&quot;OR&quot;-12ecootionROigrhig scholeuratinOR&quot;hormdar &quot;prep school&quot; OR “preparatory school&quot; OR &quot;senior high school&quot; OR &quot;college preparatory school&quot; OR “intermediate school&quot; OR “higher education&quot; OR “further education&quot; OR “graduate school education&quot; OR &quot;tertiary-level education&quot; OR &quot;university education&quot;) OR (&quot;gaming elements&quot; OR &quot;gaming mechanics&quot; OR &quot;gaming components&quot; OR “gaming factors&quot; OR &quot;gaming constituent&quot;) (&quot;gamification&quot; OR &quot;gamified&quot;,OR&quot;gamified environment&quot;,OR &quot;gamified application&quot;,OR&quot;applied game design&quot;,)AND(&quot;scientific education&quot; OR &quot;science</td><td>Published since 2012</td><td>300</td></tr><tr><td>SpringerLink</td><td>teaching&quot; OR &quot;teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR &quot;physics&quot; OR &quot;biology&quot; OR &quot;astronomy&quot; OR &quot;natural sciences&quot; OR &quot;earth sciences&quot;)AND(&quot;education&quot; OR &quot;primary education&quot; OR&quot;elementary educaion&quot;OR&quot;K-12 ecotionOnorhlgdsholeucatinORhondary &quot;prep school&quot; OR &quot;preparatory school&quot; OR &quot;senior high school&quot; OR &quot;college preparatory school&quot; OR “intermediate school&quot; OR &quot;higher education&quot; OR “further education&quot; OR “graduate school education&quot; OR“tertiary-level education&quot; OR &quot;university education&quot;) OR(&quot;gaming elements&quot; OR &quot;gaming mechanics&quot; OR &quot;gaming components&quot; OR &quot;gaming factors&quot; OR “gaming constituent&quot;)</td><td>Published since 2012</td><td>300</td></tr></table></body></html>

Table A2. Cont.   

<html><body><table><tr><td>Data Source</td><td>Search Strings (&quot;gamification&quot; OR &quot;gamified&quot;,OR &quot;gamified environment&quot;, OR &quot;gamified</td><td>Restrictions and Adjustments</td><td>Total Articles Identified</td></tr><tr><td>Sage Journals</td><td>application&quot;,OR &quot;applied game design&quot;,) AND(&quot;scientific education&quot; OR &quot;science teaching&quot; OR &quot;teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR &quot;physics&quot; OR &quot;biology&quot; OR &quot;astronomy&quot; OR &quot;natural sciences&quot; OR &quot;earth sciences&quot;) AND(&quot;education&quot; OR &quot;primary education&quot; OR &quot;elementary education&quot; OR &quot;K-12 education&quot; OR &quot;graded school education&quot; OR &quot;secondary education&quot; OR “high school&quot; OR “junior high school&quot; OR “middle school&quot; OR&quot; &quot;prep school&quot; OR &quot;preparatory school&quot; OR &quot;senior high school&quot; OR &quot;college preparatory school&quot; OR “intermediate school&quot; OR “higher education&quot; OR “further education&quot; OR &quot;graduate school education&quot; OR “tertiary-level education&quot; OR &quot;university education&quot;) OR(&quot;gaming elements&quot; OR “gaming mechanics&quot; OR &quot;gaming components&quot; OR &quot;gaming factors&quot; OR &quot;gaming constituent&quot;) (&quot;gamification&quot; OR &quot;gamified&quot;,OR&quot;gamified environment&quot;,OR &quot;gamified application&quot;,OR &quot;applied game design&quot;,) AND (&quot;scientific education&quot; OR &quot;science</td><td>Published since 2012</td><td>171</td></tr><tr><td>Taylor &amp; Francis Online</td><td>teaching&quot; OR “teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR&quot;physics&quot; OR “biology&quot; OR &quot;astronomy&quot; OR “natural sciences&quot; OR &quot;earth sciences&quot;) AND(&quot;education&quot; OR &quot;primary education&quot; OR &quot;elementary education&quot; OR “K-12 education&quot; OR &quot;graded school education&quot; OR &quot;secondary education&quot; OR “high school&quot; OR “junior high school&quot; OR “middle school&quot; OR&quot; &quot;prep school&quot; OR &quot;preparatory school&quot; OR &quot;senior high school&quot; OR &quot;college preparatory school&quot; OR “intermediate school&quot; OR “higher education&quot; OR “further education&quot; OR“graduate school education&quot; OR “tertiary-level education&quot; OR &quot;university education&quot;) OR (&quot;gaming elements&quot; OR &quot;gaming mechanics&quot; OR &quot;gaming components&quot; OR &quot;gaming factors&quot; OR &quot;gaming constituent&quot;) (&quot;gamification&quot; OR &quot;gamified&quot;,OR &quot;gamified environment&quot;,OR &quot;gamified application&quot;, OR &quot;applied game design&quot;,) AND (&quot;scientific education&quot; OR &quot;science</td><td>Published since 2012</td><td>241</td></tr><tr><td>Google Scholar</td><td>teaching&quot; OR &quot;teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;,OR &quot;physics&quot; OR “biology&quot; OR &quot;astronomy&quot; OR“natural sciences&quot; OR &quot;earth sciences&quot;) AND(&quot;education&quot; OR &quot;primary education&quot; OR &quot;elementary education&quot; OR &quot;K-12 education&quot; OR &quot;graded school education&quot; OR &quot;secondary education&quot; OR &quot;high school&quot; OR &quot;junior high school&quot; OR “middle school&quot; OR &quot;prep school&quot; OR &quot;preparatory school&quot; OR &quot;senior high school&quot; OR “college preparatory school&quot; OR “intermediate school&quot; OR “higher education&quot; OR “further education&quot; OR &quot;graduate school education&quot; OR “tertiary-level education&quot; OR &quot;university education&quot;) OR (&quot;gaming elements&quot; OR &quot;gaming mechanics&quot; OR &quot;gaming components&quot; OR &quot;gaming factors&quot; OR &quot;gaming constituent&quot;)</td><td>Published since 2012</td><td>1000</td></tr></table></body></html>

Table A2. Cont.   

<html><body><table><tr><td>Data Source</td><td>Search Strings</td><td>Restrictions and Adjustments Published since 2012</td><td>Total Articles Identified</td></tr><tr><td>ISTOR</td><td>(&quot;gamification&quot; OR &quot;gamified&quot;,OR “gamified environment&quot;,OR “gamified application&quot;,OR “applied game design&quot;,)AND(&quot;scientific education&quot; OR &quot;science toaching&quot;ORytechingof gyreR,ORPusistrsice 201&quot;sienctrorgomyto &quot;natural sciences&quot; OR &quot;earth sciences&quot;) AND (&quot;education&quot;) OR (&quot;gaming elements&quot;)</td><td>Restriction in characters in the search string (200 characters mdu)-Coreeadkaming elements were adjusted. Multiple searches were conducted base on each synonym in Science education</td><td>368</td></tr><tr><td>ScienceDirect</td><td>(&quot;gamification&quot; OR &quot;gamified&quot;,OR “gamified environment&quot;,OR &quot;gamified application&quot;, OR &quot;applied game design&quot;,) AND (&quot;scientific education&quot; OR &quot;science teaching&quot; OR “teaching of science&quot;,OR &quot;science education&quot; OR &quot;chemistry&quot; OR &quot;geology&quot;, OR &quot;physics&quot; OR &quot;biology&quot; OR “astronomy&quot; OR &quot;natural sciences&quot; OR &quot;earth sciences&quot;) AND (&quot;education&quot;) OR (&quot;gaming elements&quot;)</td><td>： Published since 2012 ： Restriction in boolean connectors in the search string (max 8)-Core concepts like educational level and gaming elements were restricted. Multiple searches were conducted base on each synonym in Science education</td><td>3300</td></tr></table></body></html>

# References

1. Baeten, M.; Struyven, K.; Dochy, F. Student-Centred Teaching Methods: Can They Optimise Students’ Approaches to Learning in Professional Higher Education? Stud. Educ. Eval. 2013, 39, 14–22.   
2. National Research Council. Exploring the Intersection of Science Education and 21st Century Skills: A Workshop Summary; National Academies Press: Washington, DC, USA, 2010.   
3. Morris, B.J.; Croker, S.; Zimmerman, C.; Gill, D.; Romig, C. Gaming Science: The “Gamification” of Scientific Thinking. Front. Psychol. 2013, 4, 607. [CrossRef] [PubMed]   
4. Landers, R.N.; Bauer, K.N.; Callan, R.C.; Armstrong, M.B. Psychological Theory and the Gamification of Learning. In Gamification in Education and Business; Springer: Cham, Switzerland, 2015; pp. 165–186.   
5. Dicheva, D.; Dichev, C.; Agre, G.; Angelova, G. Gamification in Education: A Systematic Mapping Study. J. Educ. Technol. Soc. 2015, 18, 75–88.   
6. Papadakis, S.; Marios Trampas, A.; Barianos, A.K.; Kalogiannakis, M.; Vidakis, N. Evaluating the Learning Process: The “ThimelEdu” Educational Game Case Study. In Proceedings of the 12th International Conference on Computer Supported Education (CSEDU 2020), Prague, Czech Republic, 2–4 May 2020; Volume 2, pp. 290–298, ISBN 978-989-758-417-6.   
7. Kapp, K.M. The Gamification of Learning and Instruction: Game-Based Methods and Strategies for Training and Education. Int. J. Gaming Comput. Simul. 2012, 4, 81–83.   
8. Zimmerling, E.; Höllig, C.E.; Sandner, P.G.; Welpe, I.M. Exploring the Influence of Common Game Elements on Ideation Output and Motivation. J. Bus. Res. 2019, 94, 302–312.   
9. Papadakis, S.; Kalogiannakis, M. Using Gamification for Supporting an Introductory Programming Course. The Case of Classcraft in a Secondary Education Classroom. In Lecture Notes of the Institute for Computer Sciences, Social-Informatics and Telecommunications Engineering, LNICST; Springer: Cham, Switzerland, 2018; Volume 229, pp. 366–375.   
10. Kalogiannakis, M.; Papadakis, S. Combining Mobile Technologies in Environmental Education: A Greek Case Study. Int. J. Mob. Learn. Organ. 2017, 11, 108–130. [CrossRef]   
11. Loganathan, P.; Talib, C.; Thoe, N.; Aliyu, F.; Zawadski, R. Implementing Technology Infused Gamification in Science Classroom: A Systematic Review and Suggestions for Future Research. Learn. Sci. Math. 2019, 14, 60–73.   
12. Vidakis, N.; Barianos, A.K.; Trampas, A.M.; Papadakis, S.; Kalogiannakis, M.; Vassilakis, K. Game Raw Data Collection and Visualization in the Context of the “ThimelEdu” Educational Game. In Computer Supported Education. CSEDU 2019. Communications in Computer and Information Science; Lane, H.C., Zvacek, S., Uhomoibhi, J., Eds.; Springer: Cham, Switzerland, 2020; Volume 1220. [CrossRef]   
13. Suh, A.; Wagner, C.; Liu, L. Enhancing User Engagement through Gamification. J. Comput. Inf. Syst. 2018, 58, 204–213.   
14. Subhash, S.; Cudney, E.A. Gamified Learning in Higher Education: A Systematic Review of the Literature. Comput. Hum. Behav. 2018, 87, 192–206.   
15. Zainuddin, Z.; Chu, S.K.W.; Shujahat, M.; Perera, C.J. The Impact of Gamification on Learning and Instruction: A Systematic Review of Empirical Evidence. Educ. Res. Rev. 2020, 30, 100326.   
16. Hamari, J.; Koivisto, J.; Sarsa, H. Does Gamification Work?—A Literature Review of Empirical Studies on Gamification. In Proceedings of the Annual Hawaii International Conference on System Sciences, Waikoloa, HI, USA, 6–9 January 2014; pp. 3025–3034.   
17. Rapp, A.; Hopfgartner, F.; Hamari, J.; Linehan, C.; Cena, F. Strengthening Gamification Studies: Current Trends and Future Opportunities of Gamification Research. Int. J. Hum. Comput. Stud. 2019, 127, 1–6. [CrossRef]   
18. Mora, A.; Riera, D.; González, C.; Arnedo-Moreno, J. Gamification: A Systematic Review of Design Frameworks. J. Comput. High. Educ. 2017, 29, 516–548. [CrossRef]   
19. Dieste, O.; Padua, A.G. Developing Search Strategies for Detecting Relevant Experiments for Systematic Reviews. In Proceedings of the First International Symposium on Empirical Software Engineering and Measurement (ESEM 2007), Madrid, Spain, 20–21 September 2007; pp. 215–224.   
20. Drolia, M.; Sifaki, E.; Papadakis, S.; Kalogiannakis, M. An Overview of Mobile Learning for Refugee Students: Juxtaposing Refugee Needs with Mobile Applications’ Characteristics. Challenges 2020, 11, 31.   
21. Richter, G.; Raban, D.R.; Rafaeli, S. Studying Gamification: The Effect of Rewards and Incentives on Motivation. In Gamification in Education and Business; Springer: Cham, Switzerland, 2015; pp. 21–46.   
22. Klock, A.C.T.; Ogawa, A.N.; Gasparini, I.; Pimenta, M.S. Does Gamification Matter: A Systematic Mapping about the Evaluation of Gamification in Educational Environments. In Proceedings of the ACM Symposium on Applied Computing; Association for Computing Machinery: New York, NY, USA, 2018; Volume 7, pp. 2006–2012.   
23. Hu, J. Gamification in Learning and Education: Enjoy Learning Like Gaming. Br. J. Educ. Stud. 2020, 68, 265–267. [CrossRef]   
24. Landers, R.N. Developing a Theory of Gamified Learning. Simul. Gaming 2014, 45, 752–768. [CrossRef]   
25. Werbach, K. (Re)Defining Gamification: A Process Approach. In Lecture Notes in Computer Science (including Subseries Lecture Notes in Artificial Intelligence and Lecture Notes in Bioinformatics); Springer: Cham, Switzerland, 2014; Volume 8462, pp. 266–272.   
26. Sailer, M.; Hense, J.U.; Mayr, S.K.; Mandl, H. How Gamification Motivates: An Experimental Study of the Effects of Specific Game Design Elements on Psychological Need Satisfaction. Comput. Hum. Behav. 2017, 69, 371–380.   
27. Hsin-Yuan Huang, W.; Soman, D. A Practitioner’s Guide to Gamification of Education. Research Report Series Behavioural Economics in Action; University of Toronto: Toronto, ON, Canada, 2013.   
28. Kam, A.H.; Umar, I.N. Fostering Authentic Learning Motivations through Gamification: A Self-Determination Theory (SDT) Approach. J. Eng. Sci. Technol. 2018, 13, 1–9.   
29. Strmeˇcki, D.; Bernik, A.; Radoševi´c, D. Gamification in E-Learning: Introducing Gamified Design Elements into e-Learning Systems. J. Comput. Sci. 2015, 11, 1108–1117.   
30. Huang, H.M.; Rauch, U.; Liaw, S.S. Investigating Learners’ Attitudes toward Virtual Reality Learning Environments: Based on a Constructivist Approach. Comput. Educ. 2010, 55, 1171–1182. [CrossRef]   
31. Ijaz, K.; Bogdanovych, A.; Trescak, T. Virtual Worlds vs. Books and Videos in History Education. Interact. Learn. Environ. 2017, 25, 904–929. [CrossRef]   
32. Buckley, P.; Doyle, E. Gamification and Student Motivation. Interact. Learn. Environ. 2016, 24, 1162–1175. [CrossRef]   
33. Nand, K.; Baghaei, N.; Casey, J.; Barmada, B.; Mehdipour, F.; Liang, H.-N. Engaging Children with Educational Content via Gamification. Smart Learn. Environ. 2019, 6, 1–15. [CrossRef]   
34. Van Roy, R.; Zaman, B. Need-Supporting Gamification in Education: An Assessment of Motivational Effects over Time. Comput. Educ. 2018, 127, 283–297. [CrossRef]   
35. Ryan, R.M.; Deci, E.L. Intrinsic and Extrinsic Motivations: Classic Definitions and New Directions. Contemp. Educ. Psychol. 2000, 25, 54–67. [CrossRef]   
36. Deci, E.L.; Ryan, R.M. Handbook of Self-Determination Research; University Rochester Press: Rochester, NY, USA, 2004.   
37. Vansteenkiste, M.; Soenens, B. Motivational Profiles from a Self-Determination Perspective: The Quality of Motivation Matters Tribute to Willy Lens View Project Parent-Child Talk about the Past: The Antecedent Role of Mindful Parenting and Children’s Externalizing Problems in Parent-Child Reminiscing and the Effect on Children’s Emotion Regulation View Project Motivational Profiles from a Self-Determination Perspective: The Quality of Motivation Matters. Artic. J. Educ. Psychol. 2009, 101, 671–688.   
38. Cerasoli, C.P.; Nicklin, J.M.; Ford, M.T. Intrinsic Motivation and Extrinsic Incentives Jointly Predict Performance: A 40-Year Meta-Analysis. Psychol. Bull. 2014, 140, 980–1008. [CrossRef]   
39. Deci, E.L.; Koestner, R.; Ryan, R.M. A Meta-Analytic Review of Experiments Examining the Effects of Extrinsic Rewards on Intrinsic Motivation. Psychol. Bull. 1999, 125, 627–668. [CrossRef]   
40. Ryan, R.; Deci, E. Promoting Self-Determined School Engagement: Motivation, Learning, and Well-Being. In Handbook of Motivation at School; Wenzel, K.R., Wigfield, A., Eds.; Educational Psychology Handbook Series; Routledge/Taylor & Francis Group: Abingdon, UK, 2009.   
41. Skinner, E.; Furrer, C.; Marchand, G.; Kindermann, T. Engagement and Disaffection in the Classroom: Part of a Larger Motivational Dynamic? J. Educ. Psychol. 2008, 100, 765–781.   
42. Przybylski, A.K.; Ryan, R.M.; Rigby, C.S. The Motivating Role of Violence in Video Games. Personal. Soc. Psychol. Bull. 2009, 35, 243–259. [CrossRef]   
43. Rigby, S.; Ryan, R. Glued to Games: How Video Games Draw Us in and Hold Us Spellbound: How Video Games Draw Us in and Hold Us Spellbound; AbC-CLIo: Santa Barbara, CA, USA, 2011.   
44. Seaborn, K.; Fels, D.I. Gamification in Theory and Action: A Survey. Int. J. Hum. Comput. Stud. 2015, 74, 14–31. [CrossRef]   
45. Locke, E.A.; Latham, G.P. Building a Practically Useful Theory of Goal Setting and Task Motivation: A 35-Year Odyssey. Am. Psychol. 2002, 57, 705–717. [CrossRef] [PubMed]   
46. Locke, E.A.; Latham, G.P. New Directions in Goal-Setting Theory. Curr. Dir. Psychol. Sci. 2006, 15, 265–268. [CrossRef]   
47. Huang, B.; Hew, K.F. Implementing a Theory-Driven Gamification Model in Higher Education Flipped Courses: Effects on out-of-Class Activity Completion and Quality of Artifacts. Comput. Educ. 2018, 125, 254–272.   
48. Csikszentmihalyi, M. Flow: The Psychology of Optimal Experience. Perennial Modern Classics; Harper & Row: New York, NY, USA, 1990.   
49. Chen, J. Flow in Games (and Everything Else). Commun. ACM 2007, 50, 31–34. [CrossRef]   
50. Jackson, S.A. The Oxford Handbook of Human Motivation; Ryan, R., Ed.; OUP: New York, NY, USA, 2012; pp. 127–140.   
51. Matallaoui, A.; Hanner, N.; Zarnekow, R. Introduction to Gamification: Foundation and Underlying Theories. In Gamification; Springer: Cham, Switzerland, 2017; pp. 3–18.   
52. Orhan Göksün, D.; Gürsoy, G. Comparing Success and Engagement in Gamified Learning Experiences via Kahoot and Quizizz. Comput. Educ. 2019, 135, 15–29. [CrossRef]   
53. Hamari, J.; Koivisto, J. Social Motivations to Use Gamification: An Empirical Study of Gamifying Exercise. In Proceedings of the ECIS 2013: 21st European Conference on Information Systems, Utrecht, The Netherlands, 5–8 June 2013.   
54. Koivisto, J.; Hamari, J. Demographic Differences in Perceived Benefits from Gamification. Comput. Hum. Behav. 2014, 35, 179–188.   
55. Deterding, S. The Lens of Intrinsic Skill Atoms: A Method for Gameful Design. Hum. Comput. Interact. 2015, 30, 294–335.   
56. Tulloch, R.; Randell-Moon, H.E.K. The Politics of Gamification: Education, Neoliberalism and the Knowledge Economy. Rev. Educ. Pedagog. Cult. Stud. 2018, 40, 204–226.   
57. De Sousa Borges, S.; Durelli, V.H.S.; Reis, H.M.; Isotani, S. A Systematic Mapping on Gamification Applied to Education. In Proceedings of the ACM Symposium on Applied Computing; Association for Computing Machinery: New York, NY, USA, 2014; pp. 216–222. rp, J.; eview. In 8th European Conference on Games Based Learning; Academic Conferences International Limited: Reading, UK, 2014; Volume 1, pp. 50–57.   
59. Bai, S.; Hew, K.F.; Huang, B. Does Gamification Improve Student Learning Outcome? Evidence from a Meta-Analysis and Synthesis of Qualitative Data in Educational Contexts. Educ. Res. Rev. 2020, 30, 100322.   
60. Mellado, V.; Borrachero, A.B.; Brígido, M.; Melo, L.V.; Dávila, M.A.; Cañada, F.; Conde, M.C.; Costillo, E.; Cubero, J.; Esteban, R.; et al. Emotions in Science Teaching. Ensen. las Cienc. 2014, 32, 11–36.   
61. Vidakis, N.; Barianos, A.K.; Trampas, A.M.; Papadakis, S.; Kalogiannakis, M.; Vassilakis, K. Generating Education In-Game Data: The Case of an Ancient Theatre Serious Game. In CSEDU 2019—Proceedings of the 11th International Conference on Computer Supported Education; SciTePress: Heraklion, Greece, 2019; Volume 1, pp. 36–43.   
62. Borrachero, A.B.; Brigido, M.; Gomez, R.; Bermejo, M.L.; Mellado, V. Emotions in prospective secondary teachers on the science learning and teaching process (Las emociones de los futuros profesores de secundaria sobre el aprendizaje y la enseñanza de las ciencias). Int. J. Dev. Educ. Psychol. Rev. 2011, 1, 521–530.   
63. Hug, B.; Krajcik, J.S.; Marx, R.W. Using Innovative Learning Technologies to Promote Learning and Engagement in an Urban Science Classroom. Urban Educ. 2005, 40, 446–472. [CrossRef]   
64. Slykhuis, D.; Slykhuis, D.; Krall, R. Teaching Science with Technology: A Decade of Research. In Proceedings of the Society for Information Technology & Teacher Education International Conference, Nashville, TN, USA, 7 March 2011; pp. 4142–4151.   
65. Papadakis, S.; Kalogiannakis, M.; Zaranis, N. The Effectiveness of Computer and Tablet Assisted Intervention in Early Childhood Students’ Understanding of Numbers. An Empirical Study Conducted in Greece. Educ. Inf. Technol. 2018, 23, 1849–1871. [CrossRef]   
66. Arnold, B.J. Gamification in Education. Proc. Am. Soc. Bus. Behav. Sci. 2014, 21, 32–39.   
67. Kim, S.; Song, K.; Lockee, B.; Burton, J.; Kim, S.; Song, K.; Lockee, B.; Burton, J. Gamification Cases in STEM Education. In Gamification in Learning and Education; Springer: Cham, Switzerland, 2018; pp. 125–139.   
68. Al-Azawi, R.; Al-Faliti, F.; Al-Blushi, M. Educational Gamification vs. Game Based Learning: Comparative Study. Int. J. Innov. Manag. Technol. 2016, 7, 132–136. [CrossRef]   
69. Chan, K.Y.G.; Tan, S.L.; Hew, K.F.T.; Koh, B.G.; Lim, L.S.; Yong, J.C. Knowledge for Games, Games for Knowledge: Designing a Digital Roll-and-Move Board Game for a Law of Torts Class. Res. Pract. Technol. Enhanc. Learn. 2017, 12, 1–20. [CrossRef]   
70. Rachels, J.R.; Rockinson-Szapkiw, A.J. The Effects of a Mobile Gamification App on Elementary Students’ Spanish Achievement and Self-Efficacy. Comput. Assist. Lang. Learn. 2018, 31, 72–89. [CrossRef]   
71. De-Marcos, L.; Domínguez, A.; Saenz-De-Navarrete, J.; Pagés, C. An Empirical Study Comparing Gamification and Social Networking on E-Learning. Comput. Educ. 2014, 75, 82–91. [CrossRef]   
72. Van Eck, R. Digital Game-Based Learning: It’s Not Just the Digital Natives Who Are Restless. Educ. Rev. 2006, 41, 1–16.   
73. Teo, T.; Fan, X.; Du, J. Technology Acceptance among Pre-Service Teachers: Does Gender Matter? Background. Australas. J. Educ. Technol. 2015, 31, 235–251. [CrossRef]   
74. Markopoulos, A.P.; Fragkou, A.; Kasidiaris, P.D.; Davim, J.P. Gamification in Engineering Education and Professional Training. Int. J. Mech. Eng. Educ. 2015, 43, 118–131. [CrossRef]   
75. Hanus, M.D.; Fox, J. Assessing the Effects of Gamification in the Classroom: A Longitudinal Study on Intrinsic Motivation, Social Comparison, Satisfaction, Effort, and Academic Performance. Comput. Educ. 2015, 80, 152–161. [CrossRef]   
76. McDaniel, R.; Lindgren, R.; Friskics, J. Using Badges for Shaping Interactions in Online Learning Environments. In Proceedings of the IEEE International Professional Communication Conference, Orlando, FL, USA, 8–10 October 2012; pp. 1–4.   
77. Sjøberg, S.; Schreiner, C. Results and Perspectives from the Rose Project. In Science Education Research and Practice in Europe; Sense Publishers: Rotterdam, The Netherlands, 2012; pp. 203–236.   
78. Erhel, S.; Jamet, E. Improving Instructions in Educational Computer Games: Exploring the Relations between Goal Specificity, Flow Experience and Learning Outcomes. Comput. Hum. Behav. 2019, 91, 106–114. [CrossRef]   
79. Huizenga, J.; Admiraal, W.; Ten Dam, G.; Voogt, J. Mobile Game-Based Learning in Secondary Education: Students’ Immersion, Game Activities, Team Performance and Learning Outcomes. Comput. Hum. Behav. 2019, 99, 137–143. [CrossRef]   
80. Khazanchi, R.; Khazanchi, R.; Khazanchi, P. Exploring Kahoot! Learning through Gaming in Secondary Science Education. In Proceedings of the Society for Information Technology & Teacher Education International Conference, Las Vegas, NV, USA, 18 March 2019; AACE: Waynesville, NC, USA, 2019; pp. 1873–1879.   
81. Bybee, R. Achieving Scientific Literacy: From Purposes to Practices; Heinemann: Portsmouth, NH, USA, 1997.   
82. Tsai, F.-H. The Development and Evaluation of a Computer-Simulated Science Inquiry Environment Using Gamified Elements. J. Educ. Comput. Res. 2018, 56, 3–22. [CrossRef]   
83. Hugerat, M.; Kortam, N. Improving Higher Order Thinking Skills among Freshmen by Teaching Science through Inquiry. Eurasia J. Math. Sci. Technol. Educ. 2014, 10, 447–454. [CrossRef]   
84. Lazonder, A.W.; Harmsen, R. Meta-Analysis of Inquiry-Based Learning: Effects of Guidance. Rev. Educ. Res. 2016, 86, 681–718. [CrossRef]   
85. Wallace, J.; Louden, W. Dilemmas of Science Teaching: Perspectives on Problems of Practice; Psychology Press: London, UK, 2002.   
86. Riga, F.; Winterbottom, M.; Harris, E.; Newby, L. Inquiry-Based Science Education. In Science Education; Brill Sense: Leiden, The Netherlands, 2017; Volume 31, pp. 247–261.   
87. McClarty, K.L.; Orr, A.; Frey, P.M.; Dolan, R.P.; Vassileva, V.; McVay, A. A Literature Review of Gaming in Education; Research Report; Pearson: London, UK, 2012.   
88. Hamari, J. Do Badges Increase User Activity? A Field Experiment on the Effects of Gamification. Comput. Hum. Behav. 2017, 71, 469–478. [CrossRef]   
89. Kelly, H. Games, Cookies, and the Future of Education. Issues Sci. Technol. 2005, 21, 33–40.   
90. Marín, B.; Frez, J.; Cruz-Lemus, J.; Genero, M. An Empirical Investigation on the Benefits of Gamification in Programming Courses. ACM Trans. Comput. Educ. 2019, 19, 1–22. [CrossRef]   
91. Zainuddin, Z. Students’ Learning Performance and Perceived Motivation in Gamified Flipped-Class Instruction. Comput. Educ. 2018, 126, 75–88. [CrossRef]   
92. Ivanova, G.; Kozov, V.; Zlatarov, P. Gamification in Software Engineering Education. In Proceedings of the 2019 42nd International Convention on Information and Communication Technology, Electronics and Microelectronics, MIPRO, Opatija, Croatia, 20–24 May 2019; pp. 1445–1450.   
93. Gatti, L.; Ulrich, M.; Seele, P. Education for Sustainable Development through Business Simulation Games: An Exploratory Study of Sustainability Gamification and Its Effects on Students’ Learning Outcomes. J. Clean. Prod. 2019, 207, 667–678. [CrossRef]   
94. Davis, K.; Sridharan, H.; Koepke, L.; Singh, S.; Boiko, R. Learning and Engagement in a Gamified Course: Investigating the Effects of Student Characteristics. J. Comput. Assist. Learn. 2018, 34, 492–503. [CrossRef]   
95. Kitchenham, B.; Pretorius, R.; Budgen, D.; Brereton, O.P.; Turner, M.; Niazi, M.; Linkman, S. Systematic Literature Reviews in Software Engineering—A Tertiary Study. Inf. Softw. Technol. 2010, 52, 792–805. [CrossRef]   
96. Moher, D.; Liberati, A.; Tetzlaff, J.; Altman, D.G. Preferred Reporting Items for Systematic Reviews and Meta-Analyses: The PRISMA Statement. PLoS Med. 2009, 6, e1000097. [CrossRef]   
97. Kitchenham, B. Procedures for Performing Systematic Reviews; Keele University: Keele, UK, 2004.   
98. Gusenbauer, M. Google Scholar to Overshadow Them All? Comparing the Sizes of 12 Academic Search Engines and Bibliographic Databases. Scientometrics 2019, 118, 177–214. [CrossRef]   
99. Petri, G.; von Wangenheim, C.G. How to Evaluate Educational Games: A Systematic. J. Univers. Comput. Sci. 2016, 22, 992–1021.   
100. Cronin, P.; Ryan, F.; Coughlan, M. Undertaking a Literature Review: A Step-by-Step Approach. Br. J. Nurs. 2008, 17, 38–43. [CrossRef]   
101. Petticrew, M.; Roberts, H. Title: Systematic Reviews in the Social Sciences: A Practical Guide; John Wiley & Sons: Hoboken, NJ, USA, 2008.   
102. Haddaway, N.R.; Collins, A.M.; Coughlin, D.; Kirk, S. The Role of Google Scholar in Evidence Reviews and Its Applicability to Grey Literature Searching. PLoS ONE 2015, 10, e0138237. [CrossRef]   
103. Braun, V.; Clarke, V. Using Thematic Analysis in Psychology. Qual. Res. Psychol. 2006, 3, 77–101. [CrossRef]   
104. Kern, F.G. The Trials and Tribulations of Applied Triangulation: Weighing Different Data Sources. Artic. J. Mix. Methods Res. 2018, 12, 166–181. [CrossRef]   
105. Sánchez-Martín, J.; Cañada-Cañada, F.; Dávila-Acedo, M.A. Just a Game? Gamifying a General Science Class at University: Collaborative and Competitive Work Implications. Think. Ski. Creat. 2017, 26, 51–59. [CrossRef]   
106. Bjaelde, O.E.; Pedersen, M.K.; Sherson, J. Gamification of Quantum Mechanics Teaching. In Proceedings of the E-Learn: World Conference on E-Learning in Corporate, Government, Healthcare, and Higher Education, New Orleans, LA, USA, 27 October 2014; AACE: San Diego, CA, USA, 2014; pp. 218–222.   
107. Sánchez-Rivas, E.; Ruiz-Palmero, J.; Sánchez-Rodríguez, J. Gamification of Assessments in the Natural Sciences Subject in Primary Education. Educ. Sci. Theory Pract. 2019, 19, 95–111.   
108. Fleischman, K.; Ariel, E. Gamification in Science Education: Gamifying Learning of Microscopic Processes in the Laboratory. Contemp. Educ. Technol. 2016, 7, 138–159. [CrossRef]   
109. López Carrillo, D.; Calonge García, A.; Rodríguez Laguna, T.; Ros Magán, G.; Alberto Lebrón Moreno, J. Using Gamification in a Teaching Innovation Project at the University of Alcalá: A New Approach to Experimental Science Practices. Electron. J. e-Learn. 2019, 17, 93–106.   
110. Sajin, M.; Namli, R.A.N.A. Gamification and effects on students’ science lesson achievement. Int. J. New Trends Educ. Their Implic. 2016, 7, 41–47.   
111. Sanmugam, M.; Abdullah, Z.; Mohamed, H.; Aris, B.; Zaid, N.M.; Suhadi, S.M. The Affiliation between Student Achievement and Elements of Gamification in Learning Science. In Proceedings of the 2016 4th International Conference on Information and Communication Technology, ICoICT 2016, Bandung, Indonesia, 25–27 May 2016; pp. 1–4.   
112. Khan, A.; Ahmad, F.H.; Malik, M.M. Use of Digital Game Based Learning and Gamification in Secondary School Science: The Effect on Student Engagement, Learning and Gender Difference. Educ. Inf. Technol. 2017, 22, 2767–2804. [CrossRef]   
113. Zamora-Polo, F.; Corrales-Serrano, M.; Sánchez-Martín, J.; Espejo-Antúnez, L. Nonscientific University Students Training in General Science Using an Active-Learning Merged Pedagogy: Gamification in a Flipped Classroom. Educ. Sci. 2019, 9, 297. [CrossRef]   
114. Yapıcı, ˙I.Ü.; Karakoyun, F. Gamification in Biology Teaching: A Sample of Kahoot Application. Turk. Online J. Qual. Inq. 2017, 8, 396–414. [CrossRef]   
115. Lai, K.H.; Foon, H.K. To Assess a Gamified 5E Flipped Learning Platform’s Effectiveness in Promoting Student Learning and Achievement in Physics: A Design-Based Research. In Shaping the Future of Education, Communication and Technology; Springer: Singapore, 2019; pp. 91–106.   
116. Pesare, E.; Roselli, T.; Corriero, N.; Rossano, V. Game-Based Learning and Gamification to Promote Engagement and Motivation in Medical Learning Contexts. Smart Learn. Environ. 2016, 3, 1–21. [CrossRef]   
117. Jenkins, D.A.; Mason, D. Gamification in General Chemistry. In Active Learning in College Science; Springer: Cham, Switzerland, 2020; pp. 439–449.   
118. Fan, K.K.; Xiao, P.W.; Su, C.H. The Effects of Learning Styles and Meaningful Learning on the Learning Achievement of Gamification Health Education Curriculum. Eurasia J. Math. Sci. Technol. Educ. 2015, 11, 1211–1229.   
119. Hursen, C.; Bas, C. Use of Gamification Applications in Science Education. Int. J. Emerg. Technol. Learn. 2019, 14, 4–23. [CrossRef]   
120. Bonde, M.T.; Makransky, G.; Wandall, J.; Larsen, M.V.; Morsing, M.; Jarmer, H.; Sommer, M.O.A. Improving Biotech Education through Gamified Laboratory Simulations. Nat. Biotechnol. 2014, 32, 694–697. [CrossRef]   
121. Kingsley, T.L.; Grabner-Hagen, M.M. Gamification. J. Adolesc. Adult Lit. 2015, 59, 51–61. [CrossRef]   
122. Owens, D.C. Overcoming Motivational Barriers to Understanding and Accepting Evolution through Gameful Learning. In Evolution Education Re-Considered; Springer: Cham, Switzerland, 2019; pp. 167–184.   
123. Jones, S.M.; Katyal, P.; Xie, X.; Nicolas, M.P.; Leung, E.M.; Noland, D.M.; Montclare, J.K. A ‘KAHOOT!’ Approach: The Effectiveness of Game-Based Learning for an Advanced Placement Biology Class. Simul. Gaming 2019, 50, 832–847. [CrossRef]   
124. Erdo ˘gdu, F.; Karatas, F.O. Examining the Effects of Gamification on Different Variables in Science Education. In Identifing Turkish Society’s Level of Scientific Literacy View Project Identifing Turkish Society’s Level of Scientific Literacy View Project; Antalya, Turkey, 2016. Available online: https://www.researchgate.net/publication/312164266_Examining_the_Effects_of_Gamification_on_ Different_Variables_in_Science_Education (accessed on 15 December 2020).   
125. Sanga Lamsari Purba, L.; Sormin, E.; Harefa, N.; Sumiyati, S. Effectiveness of Use of Online Games Kahoot! Chemical to Improve Student Learning Motivation. J. Pendidik. Kim. 2019, 11, 57–66.   
126. Asa’D, R.; Gunn, C. Improving Problem Solving Skills in Introductory Physics Using Kahoot! Phys. Educ. 2018, 53, 053001. [CrossRef]   
127. Curto Prieto, M.; Orcos Palma, L.; Blázquez Tobías, P.; León, F. Student Assessment of the Use of Kahoot in the Learning Process of Science and Mathematics. Educ. Sci. 2019, 9, 55. [CrossRef]   
128. Erzberger, C.; Prein, G. Triangulation: Validity and Empirically-Based Hypothesis Construction. Qual. Quant. 1997, 31, 141–154.   
129. Azorín, J.; Research, R.C. The Application of Mixed Methods in Organisational Research: A Literature Review. Electron. J. Bus. Res. Methods 2010, 8, 95–105.   
130. Creswell, J.W.; Hanson, W.E.; Clark Plano, V.L.; Morales, A. Qualitative Research Designs. Couns. Psychol. 2007, 35, 236–264. [CrossRef]   
131. National Research Council. A Framework for K-12 Science Education: Practices, Crosscutting Concepts, and Core Ideas; National Academies Press: Washington, DC, USA, 2012.   
132. Opfermann, M.; Schmeck, A.; Fischer, H.E. Multiple Representations in Physics and Science Education—Why Should We Use Them? Springer: Cham, Switzerland, 2017; Volume 10, pp. 1–22.   
133. Bell, T.; Urhahne, D.; Schanze, S.; Ploetzner, R. Collaborative Inquiry Learning: Models, Tools, and Challenges. Int. J. Sci. Educ. 2010, 32, 349–377. [CrossRef]   
134. Buckley, B.C. Interactive Multimedia and Model-Based Learning in Biology. Int. J. Sci. Educ. 2000, 22, 895–935. [CrossRef]   
135. Erol, M.; Bilal, E.; Erol, M. Hypothesis-Experiment-Instruction (Hei) Method for Investigation and Elimination of Misconceptions on Friction. Balk. Phys. Lett. Bogazici Univ. Press BPL 2010, 18, 269–276.   
136. Bayraktar, S. Misconceptions of Turkish Pre-Service Teachers about Force and Motion. Int. J. Sci. Math. Educ. 2009, 7, 273–291. [CrossRef]   
137. Sharma, S.V.; Sharma, K.C. Concepts of Force and Frictional Force: The Influence of Preconceptions on Learning across Different Levels. Phys. Educ. 2007, 42, 516–521. [CrossRef]   
138. Dubois, D.J.; Tamburrelli, G. Understanding Gamification Mechanisms for Software Development. In Proceedings of the 2013 9th Joint Meeting on Foundations of Software Engineering; ACM: Shanghai, China, 2013; pp. 659–662.   
139. Aparicio, M.; Oliveira, T.; Bacao, F.; Painho, M. Gamification: A Key Determinant of Massive Open Online Course (MOOC) Success. Inf. Manag. 2019, 56, 39–54. [CrossRef]   
140. Bielik, P. Integration and Adaptation of Motivational Factors into Software Systems. In Personalized Web-Science, Technologies and Engineering: 11th Spring 2012 PeWe Workshop Modra-Piesok; Mária Bieliková, P.N., Michal Barla, M.Š., Tvarožek, J., Eds.; ACM: Modra, Slovakia, 2012; pp. 31–32.   
141. Buil, I.; Catalán, S.; Martínez, E. Understanding Applicants’ Reactions to Gamified Recruitment. J. Bus. Res. 2020, 110, 41–50. [CrossRef]   
142. Papadakis, S.; Kalogiannakis, M.; Sifaki, E.; Vidakis, N. Access Moodle Using Smart Mobile Phones. A Case Study in a Greek University. In Interactivity, Game Creation, Design, Learning, and Innovation. ArtsIT 2017, DLI 2017. Lecture Notes of the Institute for Computer Sciences, Social Informatics and Telecommunications Engineering; Brooks, A., Brooks, E., Vidakis, N., Eds.; Springer: Switzerland, Cham, 2018; Volume 229, pp. 376–385.   
143. Walz, S.P.; Deterding, S. The Gameful World: Approaches, Issues, Applications; MIT Press: Cambridge, MA, USA, 2015.   
144. Tenório, M.M.; Reinaldo, F.A.F.; Góis, L.A.; Lopes, R.P.; dos Santos Junior, G. Elements of Gamification in Virtual Learning Environments: A Systematic Review. In Advances in Intelligent Systems and Computing; Springer: Cham, Switzerland, 2018; Volume 716, pp. 86–96.   
145. Ça ˘glar, ¸S.; Arkün-Kocadere, S. Gamification in Online Learning Environments. J. Educ. Sci. Pract. 2015, 14, 83–102.   
146. Glover, I. Play as You Learn: Gamification as a Technique for Motivating Learners. In Edmedia $^ +$ Innovate Learning; AACE: Waynesville, NC, USA, 2013; pp. 1999–2008.   
147. Licorish, S.A.; Owen, H.E.; Daniel, B.; George, J.L. Students’ Perception of Kahoot!’s Influence on Teaching and Learning. Res. Pract. Technol. Enhanc. Learn. 2018, 13, 1–23. [CrossRef]   
148. De Souza Sombrio, G.; Ribas Ulbricht, V.; Külkamp Haeming, W. Games and Gamification: A Proposal for a Creative Learning Process in Education. J. Educ. Hum. Dev. 2014, 3, 2334–2978.   
149. Tracy, F.; Christopher, S.; Steven, H. Game Design Workshop: A Playcentric Approach to Creating Innovative Games; CRC Press: Boca Raton, FL, USA, 2014.   
150. Berkling, K.; Thomas, C. Gamification of a Software Engineering Course and a Detailed Analysis of the Factors That Lead to It’s Failure. In Proceedings of the 2013 International Conference on Interactive Collaborative Learning, ICL 2013, Kazan, Russia, 25–27 September 2013; pp. 525–530.   
151. Thomas, C.; Berkling, K. Redesign of a Gamified Software Engineering Course. In Proceedings of the 2013 International Conference on Interactive Collaborative Learning, ICL 2013, Kazan, Russia, 25–27 September 2013; pp. 778–786.   
152. Deci, E.L.; Ryan, R.M. Overview of Self-Determination Theory: An Organismic Dialectical Perspective. In Handbook of SelfDetermination Research; Rochester: New York, NY, USA, 2002; pp. 3–33.   
153. Yildirim, I. The Effects of Gamification-Based Teaching Practices on Student Achievement and Students’ Attitudes toward Lessons. Internet High. Educ. 2017, 33, 86–92. [CrossRef]   
154. Groening, C.; Binnewies, C. “Achievement Unlocked!”—The Impact of Digital Achievements as a Gamification Element on Motivation and Performance. Comput. Hum. Behav. 2019, 97, 151–166. [CrossRef]   
155. Toda, A.M.; Klock, A.C.T.; Oliveira, W.; Palomino, P.T.; Rodrigues, L.; Shi, L.; Bittencourt, I.; Gasparini, I.; Isotani, S.; Cristea, A.I. Analysing Gamification Elements in Educational Environments Using an Existing Gamification Taxonomy. Smart Learn. Environ. 2019, 6, 1–14. [CrossRef]   
156. Schöbel, S.; Janson, A.; Jahn, K.; Kordyaka, B.; Turetken, O.; Djafarova, N.; Saqr, M.; Wu, D.; Söllner, M.; Adam, M.; et al. A Research Agenda for the Why, What, and How of Gamification Designs Results on an ECIS 2019 Panel. Commun. Assoc. Inf. Syst. 2020, 46, 30.   
157. Papadakis, S.; Vaiopoulou, J.; Kalogiannakis, M.; Stamovlasis, D. Developing and Exploring an Evaluation Tool for Educational Apps (E.T.E.A.) Targeting Kindergarten Children. Sustainability 2020, 12, 4201. [CrossRef]   
158. Guzsvinecz, T.; Szucs, V. Designing Gamified Virtual Reality Applications with Sensors—A Gamification Study. In Pannonian Conference on Advances in Information Technology (PCIT 2019); University of Pannonia: Vezprem, Hungary, 2019; pp. 105–112.   
159. Högberg, J.; Shams, P.; Wästlund, E. Gamified In-Store Mobile Marketing: The Mixed Effect of Gamified Point-of-Purchase Advertising. J. Retail. Consum. Serv. 2019, 50, 298–304. [CrossRef]   
160. Betz, S.; Székely, É.; Zarrieß, S.; Schröer, M.; Schade, L.; Wagner, P. Hesitation Processing Analysis Using Continuous MouseTracking and Gamification. In Elektronische Sprachsignalverarbeitung 2020. Tagungsband der 31 Konferenz; Wendemuth, A., Böck, R., Siegert, I., Eds.; Studientexte zur Sprachkommunikation; TUD Press: Dresden, Germany, 2020; pp. 85–92.   
161. Lin, H.Z.S.; Chiou, G.F. Effects of Comparison and Game-Challenge on Sixth Graders’ Algebra Variable Learning Achievement, Learning Attitude, and Meta-Cognitive Awareness. Eurasia J. Math. Sci. Technol. Educ. 2017, 13, 2627–2644.   
162. Schawbel, D. Adam Penenberg: How Gamification Is Going to Change the Workplace; Forbes: Ewing, NJ, USA, 2013.   
163. Literacy, S.E.-N. Overview of Research on the Educational Use of Video Games. Nord. J. Digit. Lit. 2006, 1, 184–214.   
164. Tulloch, R. The Construction of Play: Rules, Restrictions, and the Repressive Hypothesis. Games Cult. 2014, 9, 335–350. [CrossRef]   
165. Jackson, A.; Gaudet, L.; McDaniel, L.; Brammer, D. Curriculum Integration: The Use of Technology to Support Learning. J. Coll. Teach. Learn. 2011, 6. [CrossRef]   
166. Codish, D.; Ravid, G. Detecting Playfulness in Educational Gamification through Behavior Patterns. IBM J. Res. Dev. 2015, 59, 1–14. [CrossRef]   
167. Klock, A.C.; Gasparini, I.; Pimenta, M.S.; de Oliveira, J.P.M. “Everybody Is Playing the Game, but Nobody’s Rules Are the Same”: Towards Adaptation of Gamification Based on Users’ Characteristics. Bull. IEEE Tech. Comm. Learn. Technol. 2015, 17, 22–25.   
168. Squire, K. Changing the Game: What Happens When Video Games Enter the Classroom? Innov. J. Online Educ. 2005, 1.   
169. Egger, M.; Smith, G.D.; Schneider, M.; Minder, C. Bias in Meta-Analysis Detected by a Simple, Graphical Test. Br. Med. J. 1997, 315, 629–634. [CrossRef]   
170. Moher, D.; Shamseer, L.; Clarke, M.; Ghersi, D.; Liberati, A.; Petticrew, M.; Shekelle, P.; Stewart, L.A.; Estarli, M.; Barrera, E.S.A.; et al. Preferred Reporting Items for Systematic Review and Meta-Analysis Protocols (PRISMA-P) 2015 Statement. Rev. Esp. Nutr. Hum. Diet. 2016, 20, 148–160. [CrossRef]   
171. Thomé, A.M.T.; Scavarda, L.F.; Scavarda, A.J. Conducting Systematic Literature Review in Operations Management. Prod. Plan. Control 2016, 27, 408–420. [CrossRef]   
172. Papadakis, S.; Kalogiannakis, M.; Sifaki, E.; Vidakis, N. Evaluating Moodle use via Smart Mobile Phones. A case study in a Greek University. EAI Endorsed Trans. Creat. Technol. 2018, 5, 156382. [CrossRef]   
173. Transforming American Education: Learning Powered by Technology; Department of Education, Office of Educational Technology: Washington, DC, USA, 2010.   
174. Chow, C.Y.; Riantiningtyas, R.R.; Kanstrup, M.B.; Papavasileiou, M.; Liem, G.D.; Olsen, A. Can Games Change Children’s Eating Behaviour? A Review of Gamification and Serious Games. Food Qual. Prefer. 2020, 80, 103823. [CrossRef]   
175. Huang, R.; Ritzhaupt, A.D.; Sommer, M.; Zhu, J.; Stephen, A.; Valle, N.; Hampton, J.; Li, J. The Impact of Gamification in Educational Settings on Student Learning Outcomes: A Meta-Analysis. Educ. Technol. Res. Dev. 2020, 68, 1875–1901. [CrossRef]   
176. Bayram, Z.; Oskay, Ö.Ö.; Erdem, E.; Özgür, S.D.; ¸Sen, ¸S. Effect of Inquiry Based Learning Method on Students’ Motivation. Procedia Soc. Behav. Sci. 2013, 106, 988–996.   
177. Zourmpakis, A.I.; Papadakis, S.; Kalogiannakis, M. Education of Preschool and Elementary Teachers on the Use of Adaptive Gamification in Science Education. Int. J. Technol. Enhanc. Learn. (Forthcom. Artic.) 2020.